/*
 * Decompiled with CFR 0.152.
 */
package banner.util;

public class RankedList<E> {
    private double[] values;
    private E[] objects;
    private int sizeVal = 0;

    public RankedList(int maxSize) {
        this.values = new double[maxSize];
        this.objects = new Object[maxSize];
    }

    public void add(double value2, E obj) {
        if (Double.isNaN(value2)) {
            return;
        }
        int index = this.sizeVal;
        while (index > 0 && value2 > this.values[index - 1]) {
            if (index < this.objects.length) {
                this.values[index] = this.values[index - 1];
                this.objects[index] = this.objects[index - 1];
            }
            --index;
        }
        if (index < this.objects.length) {
            this.values[index] = value2;
            this.objects[index] = obj;
            if (this.sizeVal < this.objects.length) {
                ++this.sizeVal;
            }
        }
    }

    public int find(E obj) {
        int i = 0;
        while (i < this.sizeVal) {
            if (this.objects[i].equals(obj)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void clear() {
        this.sizeVal = 0;
    }

    public E getObject(int rank) {
        if (rank >= this.sizeVal) {
            throw new IndexOutOfBoundsException();
        }
        return this.objects[rank];
    }

    public double getValue(int rank) {
        if (rank >= this.sizeVal) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[rank];
    }

    public int maxSize() {
        return this.objects.length;
    }

    public int size() {
        return this.sizeVal;
    }
}

