/*
 * Decompiled with CFR 0.152.
 */
package banner.tokenization;

import banner.tokenization.Tokenizer;
import banner.types.Sentence;
import banner.types.Token;
import java.util.ArrayList;
import java.util.List;

public class SimpleTokenizer
implements Tokenizer {
    private static boolean isPunctuation(char ch) {
        return "`~!@#$%^&*()-\u2013=_+[]\\{}|;':\",./<>?".indexOf(ch) != -1;
    }

    @Override
    public void tokenize(Sentence sentence) {
        String text2 = sentence.getText();
        int start = 0;
        int i = 1;
        while (i - 1 < text2.length()) {
            char current = text2.charAt(i - 1);
            char next2 = '\u0000';
            if (i < text2.length()) {
                next2 = text2.charAt(i);
            }
            if (Character.isSpaceChar(current)) {
                start = i;
            } else if (Character.isLetter(current) || Character.isDigit(current)) {
                if (!Character.isLetter(next2) && !Character.isDigit(next2)) {
                    sentence.addToken(new Token(sentence, start, i));
                    start = i;
                }
            } else if (SimpleTokenizer.isPunctuation(current)) {
                sentence.addToken(new Token(sentence, start, i));
                start = i;
            }
            ++i;
        }
        if (start < text2.length()) {
            sentence.addToken(new Token(sentence, start, text2.length()));
        }
    }

    @Override
    public List<String> getTokens(String text2) {
        int start = 0;
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 1;
        while (i - 1 < text2.length()) {
            char current = text2.charAt(i - 1);
            char next2 = '\u0000';
            if (i < text2.length()) {
                next2 = text2.charAt(i);
            }
            if (Character.isSpaceChar(current)) {
                start = i;
            } else if (Character.isLetter(current) || Character.isDigit(current)) {
                if (!Character.isLetter(next2) && !Character.isDigit(next2)) {
                    tokens.add(text2.substring(start, i));
                    start = i;
                }
            } else if (SimpleTokenizer.isPunctuation(current)) {
                tokens.add(text2.substring(start, i));
                start = i;
            }
            ++i;
        }
        if (start < text2.length()) {
            tokens.add(text2.substring(start, text2.length()));
        }
        return tokens;
    }
}

