/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Pattern;

public class TokenWordClass
extends Pipe {
    private static final long serialVersionUID = 8996255757211528445L;
    String prefix;
    Pattern matchingRegex;
    boolean brief;

    public TokenWordClass(String prefix, Pattern matchingRegex, boolean brief) {
        this.prefix = prefix;
        this.matchingRegex = matchingRegex;
        this.brief = brief;
    }

    public TokenWordClass(String prefix, boolean brief) {
        this.prefix = prefix;
        this.matchingRegex = null;
        this.brief = brief;
    }

    private TokenWordClass() {
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        int i = 0;
        while (i < ts.size()) {
            Token t = (Token)ts.get(i);
            String text2 = t.getText();
            if (this.brief) {
                text2 = text2.replaceAll("[A-Z]+", "A");
                text2 = text2.replaceAll("[a-z]+", "a");
                text2 = text2.replaceAll("[0-9]+", "0");
                text2 = text2.replaceAll("[^A-Za-z0-9]+", "x");
            } else {
                text2 = text2.replaceAll("[A-Z]", "A");
                text2 = text2.replaceAll("[a-z]", "a");
                text2 = text2.replaceAll("[0-9]", "0");
                text2 = text2.replaceAll("[^A-Za-z0-9]", "x");
            }
            if (this.matchingRegex == null || this.matchingRegex.matcher(text2).matches()) {
                String featureName = null;
                featureName = this.prefix == null ? text2 : String.valueOf(this.prefix) + text2;
                t.setFeatureValue(featureName, 1.0);
            }
            ++i;
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.prefix);
        out.writeObject(this.matchingRegex);
        out.writeBoolean(this.brief);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.prefix = (String)in.readObject();
        this.matchingRegex = (Pattern)in.readObject();
        this.brief = in.readBoolean();
    }
}

