/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.tagging.TagFormat;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.TokenSequence;
import java.util.List;
import java.util.Set;

public class Sentence2TokenSequence
extends Pipe {
    private static final long serialVersionUID = 1L;
    private TagFormat format;
    private Set<Mention.MentionType> mentionTypes;
    private Sentence.OverlapOption sameType;
    private Sentence.OverlapOption differentType;

    public Sentence2TokenSequence(TagFormat format2, Set<Mention.MentionType> mentionTypes, Sentence.OverlapOption sameType, Sentence.OverlapOption differentType) {
        super(null, new LabelAlphabet());
        this.format = format2;
        this.mentionTypes = mentionTypes;
        this.sameType = sameType;
        this.differentType = differentType;
    }

    @Override
    public Instance pipe(Instance carrier) {
        Sentence sentence = (Sentence)carrier.getData();
        List<Token> tokens = sentence.getTokens();
        int size2 = tokens.size();
        TokenSequence data2 = new TokenSequence(size2);
        LabelSequence target = new LabelSequence((LabelAlphabet)this.getTargetAlphabet(), size2);
        List<String> labels = sentence.getTokenLabels(this.format, this.mentionTypes, this.sameType, this.differentType);
        int i = 0;
        while (i < size2) {
            String text2 = tokens.get(i).getText();
            data2.add(new cc.mallet.types.Token(text2));
            target.add(labels.get(i));
            ++i;
        }
        carrier.setData(data2);
        carrier.setTarget(target);
        carrier.setSource(sentence);
        return carrier;
    }
}

