/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging.pipe;

import banner.types.Sentence;
import banner.types.Token;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.TokenSequence;
import dragon.nlp.Word;
import dragon.nlp.tool.Lemmatiser;
import dragon.nlp.tool.Tagger;
import java.util.List;

public class LemmaPOS
extends Pipe {
    private static final long serialVersionUID = 1L;
    private boolean expectLemmatiser;
    private boolean expectPOSTagger;
    private transient Lemmatiser lemmatiser = null;
    private transient Tagger posTagger = null;

    public LemmaPOS(Lemmatiser lemmatiser, Tagger posTagger) {
        this.lemmatiser = lemmatiser;
        this.expectLemmatiser = lemmatiser != null;
        this.posTagger = posTagger;
        this.expectPOSTagger = posTagger != null;
    }

    public void setLemmatiser(Lemmatiser lemmatiser) {
        this.lemmatiser = lemmatiser;
    }

    public void setPosTagger(Tagger posTagger) {
        this.posTagger = posTagger;
    }

    @Override
    public Instance pipe(Instance carrier) {
        int i;
        if (this.expectLemmatiser != (this.lemmatiser != null)) {
            throw new IllegalStateException("Model was trained with lemmatiser; not present in current config");
        }
        if (this.expectPOSTagger != (this.posTagger != null)) {
            throw new IllegalStateException("Model was trained with POS tagger; not present in current config");
        }
        Sentence sentence = (Sentence)carrier.getSource();
        List<Token> tokens = sentence.getTokens();
        dragon.nlp.Sentence posSentence = null;
        if (this.posTagger != null) {
            int size2 = tokens.size();
            posSentence = new dragon.nlp.Sentence();
            i = 0;
            while (i < size2) {
                posSentence.addWord(new Word(tokens.get(i).getText()));
                ++i;
            }
            this.posTagger.tag(posSentence);
        }
        TokenSequence ts = (TokenSequence)carrier.getData();
        i = 0;
        while (i < ts.size()) {
            Token bannerToken = tokens.get(i);
            String text2 = bannerToken.getText();
            cc.mallet.types.Token token2 = (cc.mallet.types.Token)ts.get(i);
            if (posSentence != null) {
                String featureName = "POS=" + posSentence.getWord(i).getPOSIndex();
                token2.setFeatureValue(featureName, 1.0);
            }
            if (this.lemmatiser != null) {
                String lemma = posSentence == null ? this.lemmatiser.lemmatize(text2) : this.lemmatiser.lemmatize(text2, posSentence.getWord(i).getPOSIndex());
                String featureName = "LEMMA=" + lemma;
                token2.setFeatureValue(featureName, 1.0);
                token2.setProperty("LEMMA", lemma);
            }
            ++i;
        }
        return carrier;
    }
}

