/*
 * Decompiled with CFR 0.152.
 */
package banner.tagging;

import banner.tagging.TagFormat;
import banner.types.Mention;

public enum TagPosition {
    I,
    O,
    B,
    E,
    W;


    public TagPosition convert(TagFormat format2) {
        if (this == I || this == O) {
            return this;
        }
        if (format2 == TagFormat.IO) {
            return I;
        }
        if (format2 == TagFormat.IOB) {
            if (this == E) {
                return I;
            }
            return B;
        }
        if (format2 == TagFormat.IOE) {
            if (this == B) {
                return I;
            }
            return E;
        }
        return this;
    }

    public static TagPosition getPostion(Mention mention, int index) {
        if (mention == null) {
            return O;
        }
        if (index < mention.getStart() || index >= mention.getEnd()) {
            throw new IllegalArgumentException();
        }
        if (mention.length() == 1) {
            return W;
        }
        if (index == mention.getStart()) {
            return B;
        }
        if (index == mention.getEnd() - 1) {
            return E;
        }
        return I;
    }

    public static String getPositionText(TagFormat format2, Mention mention, int index) {
        return String.valueOf(TagPosition.getPostion(mention, index).convert(format2).name()) + "-" + mention.getEntityType().getText();
    }
}

