/*
 * Decompiled with CFR 0.152.
 */
package banner.postprocessing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class ExtractAbbrev {
    private static final char delimiter = '\t';

    private boolean isValidShortForm(String str) {
        return this.hasLetter(str) && (Character.isLetterOrDigit(str.charAt(0)) || str.charAt(0) == '(');
    }

    private boolean hasLetter(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isLetter(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCapital(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isUpperCase(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Set<AbbreviationPair> extractAbbrPairs(String text2) {
        return this.extractAbbrPairs(new StringReader(text2));
    }

    private Set<AbbreviationPair> extractAbbrPairs(Reader inFile) {
        String longForm = "";
        String shortForm = "";
        String currSentence = "";
        int closeParenIndex = -1;
        int tmpIndex = -1;
        boolean newParagraph = true;
        HashSet<AbbreviationPair> pairs = new HashSet<AbbreviationPair>();
        try {
            String str;
            BufferedReader fin = new BufferedReader(inFile);
            block2: while ((str = fin.readLine()) != null) {
                if (str.length() == 0 || newParagraph && !Character.isUpperCase(str.charAt(0))) {
                    currSentence = "";
                    newParagraph = true;
                    continue;
                }
                newParagraph = false;
                str = String.valueOf(str) + " ";
                currSentence = String.valueOf(currSentence) + str;
                int openParenIndex = currSentence.indexOf(" (");
                do {
                    if (openParenIndex > -1) {
                        ++openParenIndex;
                    }
                    int sentenceEnd = Math.max(currSentence.lastIndexOf(". "), currSentence.lastIndexOf(", "));
                    if (openParenIndex != -1 || sentenceEnd != -1) {
                        if (openParenIndex == -1) {
                            currSentence = currSentence.substring(sentenceEnd + 2);
                        } else {
                            closeParenIndex = currSentence.indexOf(41, openParenIndex);
                            if (closeParenIndex > -1) {
                                sentenceEnd = Math.max(currSentence.lastIndexOf(". ", openParenIndex), currSentence.lastIndexOf(", ", openParenIndex));
                                if (sentenceEnd == -1) {
                                    sentenceEnd = -2;
                                }
                                longForm = currSentence.substring(sentenceEnd + 2, openParenIndex);
                                shortForm = currSentence.substring(openParenIndex + 1, closeParenIndex);
                            }
                        }
                    }
                    if (shortForm.length() > 0 || longForm.length() > 0) {
                        if (shortForm.length() > 1 && longForm.length() > 1) {
                            AbbreviationPair pair2;
                            StringTokenizer shortTokenizer;
                            int newCloseParenIndex;
                            if (shortForm.indexOf(40) > -1 && (newCloseParenIndex = currSentence.indexOf(41, closeParenIndex + 1)) > -1) {
                                shortForm = currSentence.substring(openParenIndex + 1, newCloseParenIndex);
                                closeParenIndex = newCloseParenIndex;
                            }
                            if ((tmpIndex = shortForm.indexOf(", ")) > -1) {
                                shortForm = shortForm.substring(0, tmpIndex);
                            }
                            if ((tmpIndex = shortForm.indexOf("; ")) > -1) {
                                shortForm = shortForm.substring(0, tmpIndex);
                            }
                            if ((shortTokenizer = new StringTokenizer(shortForm)).countTokens() > 2 || shortForm.length() > longForm.length()) {
                                tmpIndex = currSentence.lastIndexOf(" ", openParenIndex - 2);
                                String tmpStr = currSentence.substring(tmpIndex + 1, openParenIndex - 1);
                                longForm = shortForm;
                                shortForm = tmpStr;
                                if (!this.hasCapital(shortForm)) {
                                    shortForm = "";
                                }
                            }
                            if (this.isValidShortForm(shortForm) && (pair2 = this.extractAbbrPair(shortForm.trim(), longForm.trim())) != null) {
                                pairs.add(pair2);
                            }
                        }
                        currSentence = currSentence.substring(closeParenIndex + 1);
                    } else if (openParenIndex > -1) {
                        if (currSentence.length() - openParenIndex <= 200) continue block2;
                        currSentence = currSentence.substring(openParenIndex + 1);
                        continue block2;
                    }
                    shortForm = "";
                    longForm = "";
                } while ((openParenIndex = currSentence.indexOf(" (")) > -1);
            }
            fin.close();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            System.out.println(currSentence);
            System.out.println(tmpIndex);
        }
        return pairs;
    }

    /*
     * Unable to fully structure code
     */
    private String findBestLongForm(String shortForm, String longForm) {
        sIndex = shortForm.length() - 1;
        lIndex = longForm.length() - 1;
        while (sIndex >= 0) {
            block3: {
                currChar = Character.toLowerCase(shortForm.charAt(sIndex));
                if (Character.isLetterOrDigit(currChar)) ** GOTO lbl8
                break block3;
lbl-1000:
                // 1 sources

                {
                    --lIndex;
lbl8:
                    // 2 sources

                    ** while (lIndex >= 0 && Character.toLowerCase((char)longForm.charAt((int)lIndex)) != currChar || sIndex == 0 && lIndex > 0 && Character.isLetterOrDigit((char)longForm.charAt((int)(lIndex - 1))))
                }
lbl9:
                // 1 sources

                if (lIndex < 0) {
                    return null;
                }
                --lIndex;
            }
            --sIndex;
        }
        lIndex = longForm.lastIndexOf(" ", lIndex) + 1;
        return longForm.substring(lIndex);
    }

    private AbbreviationPair extractAbbrPair(String shortForm, String longForm) {
        if (shortForm.length() == 1) {
            return null;
        }
        String bestLongForm = this.findBestLongForm(shortForm, longForm);
        if (bestLongForm == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(bestLongForm, " \t\n\r\f-");
        int longFormSize = tokenizer.countTokens();
        int shortFormSize = shortForm.length();
        int i = shortFormSize - 1;
        while (i >= 0) {
            if (!Character.isLetterOrDigit(shortForm.charAt(i))) {
                --shortFormSize;
            }
            --i;
        }
        if (bestLongForm.length() < shortForm.length() || bestLongForm.indexOf(String.valueOf(shortForm) + " ") > -1 || bestLongForm.endsWith(shortForm) || longFormSize > shortFormSize * 2 || longFormSize > shortFormSize + 5 || shortFormSize > 10) {
            return null;
        }
        return new AbbreviationPair(shortForm, bestLongForm);
    }

    public static void main(String[] args) throws IOException {
        ExtractAbbrev extractAbbrev = new ExtractAbbrev();
        String test2 = "This is a test of schwartz's excellent abbreviation tool (SEAT) on a simple example.  ABC is not defined here.";
        System.out.println(extractAbbrev.extractAbbrPairs(test2));
    }

    public class AbbreviationPair {
        private String shortForm;
        private String longForm;

        public AbbreviationPair(String shortForm, String longForm) {
            if (shortForm == null) {
                throw new IllegalArgumentException("Short form cannot be null");
            }
            if (longForm == null) {
                throw new IllegalArgumentException("Long form cannot be null");
            }
            this.shortForm = shortForm;
            this.longForm = longForm;
        }

        protected String getLongForm() {
            return this.longForm;
        }

        protected String getShortForm() {
            return this.shortForm;
        }

        public int hashCode() {
            int PRIME = 31;
            int result2 = 1;
            result2 = 31 * result2 + this.longForm.hashCode();
            result2 = 31 * result2 + this.shortForm.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbbreviationPair other = (AbbreviationPair)obj;
            if (!this.longForm.equals(other.longForm)) {
                return false;
            }
            return this.shortForm.equals(other.shortForm);
        }

        public String toString() {
            return String.valueOf(this.shortForm) + '\t' + this.longForm;
        }
    }
}

