/*
 * Decompiled with CFR 0.152.
 */
package banner.normalization;

import banner.normalization.MentionIdentifier;
import banner.normalization.Metric;
import banner.types.Entity;
import banner.types.EntityIdentification;
import banner.types.EntityName;
import banner.types.Mention;
import banner.types.Sentence;
import banner.util.Index;
import banner.util.RankedList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexedMetricIdentifier
implements MentionIdentifier {
    private Metric metric;
    private int resultsSize;
    private Index<String, Integer> elementToIndex;
    private List<EntityName> indexToName;
    private List<Integer> indexToSize;

    public IndexedMetricIdentifier(Metric metric, int resultsSize) {
        this.metric = metric;
        this.resultsSize = resultsSize;
        this.elementToIndex = new Index();
        this.indexToName = new ArrayList<EntityName>();
        this.indexToSize = new ArrayList<Integer>();
    }

    @Override
    public void addEntity(Entity entity) {
        for (EntityName name : entity.getNames()) {
            assert (this.indexToName.size() == this.indexToSize.size());
            Integer index = new Integer(this.indexToName.size());
            this.indexToName.add(name);
            this.indexToSize.add(new HashSet<String>(name.getElements()).size());
            for (String element : name.getElements()) {
                this.elementToIndex.add(this.transform(element), index);
            }
        }
    }

    private RankedList<EntityName> bruteMatch(Mention mention) {
        EntityName mentionName = EntityName.createFromTokens(mention.getText(), mention.getTokens());
        HashSet<String> elements2 = new HashSet<String>(mentionName.getElements());
        int size2 = elements2.size();
        RankedList<EntityName> results = new RankedList<EntityName>(this.resultsSize);
        for (EntityName entityName : this.indexToName) {
            HashSet<String> elements = new HashSet<String>(entityName.getElements());
            int entitySize = elements.size();
            elements.addAll(elements2);
            int union2 = elements.size();
            results.add(this.metric.similarity(union2, entitySize, size2), entityName);
        }
        return results;
    }

    private RankedList<EntityName> indexMatch(Mention mention) {
        EntityName mentionName = EntityName.createFromTokens(mention.getText(), mention.getTokens());
        int[] counts = new int[this.indexToName.size()];
        HashSet<String> mentionElementSet = new HashSet<String>(mentionName.getElements());
        HashSet<String> transformedMentionElementSet = new HashSet<String>();
        for (String element : mentionElementSet) {
            transformedMentionElementSet.add(this.transform(element));
        }
        int mentionSize = transformedMentionElementSet.size();
        for (String element : transformedMentionElementSet) {
            Set<Integer> indexSet = this.elementToIndex.lookup(element);
            if (indexSet == null) continue;
            for (Integer index : indexSet) {
                int n = index;
                counts[n] = counts[n] + 1;
            }
        }
        RankedList<EntityName> results = new RankedList<EntityName>(this.resultsSize);
        int i = 0;
        while (i < counts.length) {
            if (counts[i] > 0) {
                EntityName name = this.indexToName.get(i);
                int nameSize = this.indexToSize.get(i);
                double similarity = this.metric.similarity(counts[i], mentionSize, nameSize);
                results.add(similarity, name);
            }
            ++i;
        }
        return results;
    }

    @Override
    public void identifyMentions(Sentence sentence) {
        for (Mention mention : sentence.getMentions()) {
            EntityIdentification identification = new EntityIdentification(mention);
            RankedList<EntityName> matches2 = this.indexMatch(mention);
            int i = 0;
            while (i < matches2.size()) {
                identification.set(matches2.getObject(i), matches2.getValue(i));
                ++i;
            }
            sentence.setIdentification(mention, identification);
        }
    }

    private String transform(String element) {
        return element.toLowerCase();
    }
}

