/*
 * Decompiled with CFR 0.152.
 */
package banner.eval.dataset;

import banner.tokenization.Tokenizer;
import banner.types.EntityType;
import banner.types.Mention;
import banner.types.Sentence;
import banner.types.Token;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.HierarchicalConfiguration;

public abstract class Dataset {
    protected Tokenizer tokenizer;
    protected Set<Sentence> sentences = new HashSet<Sentence>();

    protected Dataset() {
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public abstract void load(HierarchicalConfiguration var1);

    public abstract List<Dataset> split(int var1);

    public Set<Sentence> getSentences() {
        return Collections.unmodifiableSet(this.sentences);
    }

    public Map<String, Integer> getTokenCountTotal() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Sentence sentence : this.sentences) {
            for (Token token2 : sentence.getTokens()) {
                String text2 = token2.getText();
                Integer count2 = (Integer)counts.get(text2);
                if (count2 == null) {
                    counts.put(text2, 1);
                    continue;
                }
                counts.put(text2, count2 + 1);
            }
        }
        return Collections.unmodifiableMap(counts);
    }

    public Map<String, Integer> getTokenCountMention() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Sentence sentence : this.sentences) {
            for (Mention mention : sentence.getMentions()) {
                for (Token token2 : mention.getTokens()) {
                    String text2 = token2.getText();
                    Integer count2 = (Integer)counts.get(text2);
                    if (count2 == null) {
                        counts.put(text2, 1);
                        continue;
                    }
                    counts.put(text2, count2 + 1);
                }
            }
        }
        return Collections.unmodifiableMap(counts);
    }

    public Map<EntityType, Integer> getTypeCounts() {
        HashMap<EntityType, Integer> typeCounts = new HashMap<EntityType, Integer>();
        for (Sentence sentence : this.sentences) {
            for (Mention mention : sentence.getMentions()) {
                Integer typeCount = (Integer)typeCounts.get(mention.getEntityType());
                if (typeCount == null) {
                    typeCounts.put(mention.getEntityType(), new Integer(1));
                    continue;
                }
                typeCounts.put(mention.getEntityType(), new Integer(typeCount + 1));
            }
        }
        return typeCounts;
    }

    protected static class Tag {
        public EntityType type;
        public int start;
        public int end;
        public Set<String> ids;

        public Tag(EntityType type, int start, int end) {
            this.type = type;
            this.start = start;
            this.end = end;
            this.ids = new TreeSet<String>();
        }

        public void addId(String id) {
            this.ids.add(id);
        }

        public Set<String> getIds() {
            return Collections.unmodifiableSet(this.ids);
        }

        public boolean overlaps(Tag tag) {
            return this.start <= tag.end && tag.start <= this.end;
        }

        public boolean contains(Tag tag) {
            return this.start <= tag.start && this.end >= tag.end;
        }
    }
}

