package trace;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.trace.Trace;
import org.eclipse.emf.henshin.trace.TracePackage;
import org.sidiff.difference.matcher.BaseMatcher;
import org.sidiff.difference.symmetric.Correspondence;

/**
 * Assumes that a trace links exactly two elements. Two traces are matched if
 * they link the same, i.e. corresponding, elements.
 * 
 * Note that this matcher assumes that the linked elements are matched first.
 * 
 * Note that we do not consider sub traces yet.
 * 
 * 
 * @author kehrer
 */
public class TraceMatcher extends BaseMatcher {

	public static final String KEY = "TraceMatcher";

	/**
	 * Initialize matcher and start matching.
	 */
	public TraceMatcher() {
		super();
	}

	@Override
	protected boolean isCorresponding(EObject elementA, EObject elementB) {
		assert (elementA != null && elementB != null) : "One of the elements to check for correspondence is null!";

		assert ((elementA instanceof Trace) && (elementB instanceof Trace));

		Trace tA = (Trace) elementA;
		Trace tB = (Trace) elementB;

		assert tA.getSource().size() == 1;
		assert tA.getTarget().size() == 1;
		assert tB.getSource().size() == 1;
		assert tB.getTarget().size() == 1;

		// None of the elements must be already in a correspondence
		if (isCorresponding(tA) || isCorresponding(tB)) {
			return false;
		}

		// Check scr/tgt correspondence
		return _areCorresponding(tA.getSource().get(0), tB.getSource().get(0))
				&& _areCorresponding(tA.getTarget().get(0), tB.getTarget().get(0));

	}

	private boolean _areCorresponding(EObject objA, EObject objB) {
		for (Correspondence c : getDifference().getCorrespondences()) {
			if (c.getObjA() == objA && c.getObjB() == objB) {
				return true;
			}
		}

		return false;
	}

	@Override
	public String getName() {
		return "Trace Matcher";
	}

	@Override
	public String getKey() {
		return KEY;
	}

	@Override
	public String getDocumentType() {
		return TracePackage.eNS_URI;
	}

	@Override
	public boolean canComputeReliability() {
		return false;
	}
}
