package sa;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.sidiff.difference.technical.TechnicalDifferenceBuilder;

import SA.Architecture;
import SA.SAPackage;

public class SaDifferenceBuilder extends TechnicalDifferenceBuilder {
	
	@Override
	protected Set<EClass> getUnconsideredNodeTypes() {
		Set<EClass> unconsideredNodeTypes = new HashSet<EClass>();
		
		return unconsideredNodeTypes;
	}

	@Override
	protected Set<EReference> getUnconsideredEdgeTypes() {
		Set<EReference> unconsideredEdgeTypes = new HashSet<EReference>();
		
		return unconsideredEdgeTypes;
	}

	@Override
	protected Set<EAttribute> getUnconsideredAttributeTypes() {
		Set<EAttribute> unconsideredAttributeTypes = new HashSet<EAttribute>();
		
		return unconsideredAttributeTypes;
	}
	
	@Override
	protected String getObjectName(EObject obj) {
		if (obj instanceof Architecture) {
			return "[Architecture]";
		}
		
		EStructuralFeature attrName = obj.eClass().getEStructuralFeature("name");
		return obj.eGet(attrName).toString();
	}

	@Override
	public String getDocumentType() {
		return SAPackage.eNS_URI;
	}
	
}
