/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.sidiff.difference.asymmetric.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.sidiff.difference.asymmetric.util.AsymmetricAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class AsymmetricItemProviderAdapterFactory extends AsymmetricAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the item providers created, so that they can be {@link #dispose disposed}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Disposable disposable = new Disposable();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AsymmetricItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
		supportedTypes.add(IItemColorProvider.class);
	}

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.AsymmetricDifference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAsymmetricDifferenceAdapter() {
		return new AsymmetricDifferenceItemProvider(this);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.OperationInvocation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationInvocationItemProvider operationInvocationItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.OperationInvocation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationInvocationAdapter() {
		if (operationInvocationItemProvider == null) {
			operationInvocationItemProvider = new OperationInvocationItemProvider(this);
		}

		return operationInvocationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.ObjectParameterBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ObjectParameterBindingItemProvider objectParameterBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.ObjectParameterBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createObjectParameterBindingAdapter() {
		if (objectParameterBindingItemProvider == null) {
			objectParameterBindingItemProvider = new ObjectParameterBindingItemProvider(this);
		}

		return objectParameterBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.ValueParameterBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValueParameterBindingItemProvider valueParameterBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.ValueParameterBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValueParameterBindingAdapter() {
		if (valueParameterBindingItemProvider == null) {
			valueParameterBindingItemProvider = new ValueParameterBindingItemProvider(this);
		}

		return valueParameterBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.DependencyContainer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DependencyContainerItemProvider dependencyContainerItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.DependencyContainer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDependencyContainerAdapter() {
		if (dependencyContainerItemProvider == null) {
			dependencyContainerItemProvider = new DependencyContainerItemProvider(this);
		}

		return dependencyContainerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.ParameterMapping} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterMappingItemProvider parameterMappingItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.ParameterMapping}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterMappingAdapter() {
		if (parameterMappingItemProvider == null) {
			parameterMappingItemProvider = new ParameterMappingItemProvider(this);
		}

		return parameterMappingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.ParallelExecution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParallelExecutionItemProvider parallelExecutionItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.ParallelExecution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParallelExecutionAdapter() {
		if (parallelExecutionItemProvider == null) {
			parallelExecutionItemProvider = new ParallelExecutionItemProvider(this);
		}

		return parallelExecutionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.SequentialExecution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequentialExecutionItemProvider sequentialExecutionItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.SequentialExecution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequentialExecutionAdapter() {
		if (sequentialExecutionItemProvider == null) {
			sequentialExecutionItemProvider = new SequentialExecutionItemProvider(this);
		}

		return sequentialExecutionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.MultiParameterBinding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiParameterBindingItemProvider multiParameterBindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.MultiParameterBinding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiParameterBindingAdapter() {
		if (multiParameterBindingItemProvider == null) {
			multiParameterBindingItemProvider = new MultiParameterBindingItemProvider(this);
		}

		return multiParameterBindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.NodeDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeDependencyItemProvider nodeDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.NodeDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNodeDependencyAdapter() {
		if (nodeDependencyItemProvider == null) {
			nodeDependencyItemProvider = new NodeDependencyItemProvider(this);
		}

		return nodeDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.EdgeDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EdgeDependencyItemProvider edgeDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.EdgeDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEdgeDependencyAdapter() {
		if (edgeDependencyItemProvider == null) {
			edgeDependencyItemProvider = new EdgeDependencyItemProvider(this);
		}

		return edgeDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.sidiff.difference.asymmetric.AttributeDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeDependencyItemProvider attributeDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.sidiff.difference.asymmetric.AttributeDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeDependencyAdapter() {
		if (attributeDependencyItemProvider == null) {
			attributeDependencyItemProvider = new AttributeDependencyItemProvider(this);
		}

		return attributeDependencyItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * Associates an adapter with a notifier via the base implementation, then records it to ensure it will be disposed.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void associate(Adapter adapter, Notifier target) {
		super.associate(adapter, target);
		if (adapter != null) {
			disposable.add(adapter);
		}
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		disposable.dispose();
	}

}
