package org.sidiff.patching.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.Resource.Factory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.difference.asymmetric.OperationInvocation;
import org.sidiff.difference.asymmetric.facade.AsymmetricDiffFacade;
import org.silift.common.util.exceptions.FileAlreadyExistsException;
import org.silift.common.util.file.ZipUtil;

public class PatchUtil {

	public static Resource copyWithId(Resource from, URI uri, boolean withId, Copier copier) {
		copier.copyAll(from.getContents());
		copier.copyReferences();

		Factory factory = from.getResourceSet().getResourceFactoryRegistry().getFactory(from.getURI());

		ResourceSet rs = new ResourceSetImpl();
		rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put(uri.fileExtension(), factory);
		Resource to = rs.createResource(uri);
		for (int i = 0; i < from.getContents().size(); i++) {
			to.getContents().add(copier.get(from.getContents().get(i)));
		}

		if (from instanceof XMIResource) {
			XMIResource xmlFrom = (XMIResource) from;
			for (EObject orignal : copier.keySet()) {
				EObject copy = copier.get(orignal);
				String id = withId ? xmlFrom.getID(orignal) : null;
				((XMIResource) to).setID(copy, id);
			}
		}
		return to;
	}

	public static URI createURI(URI uri, String suffix) {
		URI base = uri.trimSegments(1);
		String name = uri.trimFileExtension().lastSegment();
		String newFile = name + "_" + suffix + "." + uri.fileExtension();
		return base.appendSegment(newFile);
	}

	/**
	 * Uncompress the patch (if necessary).
	 * 
	 * @param path
	 *            The system path of the compressed patch.
	 * @return The folder of the uncompressed patch.
	 */
	public static File extractPatch(IPath path) {
		String compressedPath = path.toOSString();
		File uncompressedPath = new File(compressedPath.substring(0, compressedPath.length()
				- (AsymmetricDiffFacade.PATCH_EXTENSION.length() + 1)));

		try {
			ZipUtil.extractFiles(compressedPath, uncompressedPath.getAbsolutePath(), "", true);
		} catch (FileAlreadyExistsException e) {
			e.printStackTrace();
		}

		return uncompressedPath;
	}

	/**
	 * Checks the file extension.
	 * 
	 * @param path
	 *            The path of the patch file.
	 * @return <code>true</code> if is a patch file; <code>false</code>
	 *         otherwise.
	 */
	public static boolean isPatchFile(IPath path) {
		return (path.getFileExtension().equalsIgnoreCase(AsymmetricDiffFacade.PATCH_EXTENSION));
	}
}
