/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotators;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.sidiff.common.emf.EMFAdapter;
import org.sidiff.common.emf.EMFUtil;
import org.sidiff.common.emf.access.EMFMetaAccess;
import org.sidiff.common.emf.access.EdgeSemantic;
import org.sidiff.common.emf.annotation.AnnotateableElement;
import org.sidiff.common.emf.collections.EMFComparators;
import org.sidiff.common.exceptions.SiDiffRuntimeException;
import org.sidiff.common.util.ParamUtil;
import org.sidiff.core.annotation.Annotator;

public class HashAnnotator
extends Annotator {
    public static final String HASH_ANNOTATION_KEY = "HASH";
    private static final String NO_HASH_ECORE_ANNOTATION = "NOHASH";
    private static final String LOCAL_POS_ANNOTATION_KEY = "localPositionAnnotationKey";
    private static final String REF_POS_ANNOTATION_KEY = "referencedObjectsPositionAnnotationKey";
    private static final String GLOBAL_MOVE = "globalMoveAllowed";
    private static final String SUPPRESS_CHILDREN = "suppressChildren";
    private static final String IGNORE_ORDER = "ignoreOrder";
    private static final String EXCLUDE = "exclude";
    private static final String PARAM_ERROR_MSG = "Malformed HashAnnotator parameter string. See documentation for details!";
    private static final String DEFAULT_HASH_ALGORITHM = "SHA";
    private boolean allowGlobalMove;
    private String localPositionAnnotationKey = null;
    private String referencedObjectsPositionAnnotationKey = null;
    private Set<EReference> ignoreOrder = new HashSet<EReference>();
    private Set<EStructuralFeature> excludes = new HashSet<EStructuralFeature>();
    private Set<EReference> suppressedChildren = new HashSet<EReference>();
    private MessageDigest md = null;

    public HashAnnotator(EPackage documentType, String annotationKey, String parameter, EClass acceptedType, Collection<String> requiredAnnotations) {
        super(documentType, annotationKey, parameter, acceptedType, requiredAnnotations, Annotator.ExecutionOrder.POST);
        assert (annotationKey.equals(HASH_ANNOTATION_KEY)) : "Wrong Configuration: Annotation Key must be 'HASH'";
        ParamUtil parser = new ParamUtil();
        ParamUtil.Argument arg_localPos = parser.createParameter(LOCAL_POS_ANNOTATION_KEY, String.class, false);
        ParamUtil.Argument arg_refPos = parser.createParameter(REF_POS_ANNOTATION_KEY, String.class, false);
        ParamUtil.Argument arg_globalMove = parser.createParameter(GLOBAL_MOVE, Boolean.class, true);
        ParamUtil.Argument arg_suppressChildren = parser.createParameter(SUPPRESS_CHILDREN, LinkedList.class, false);
        ParamUtil.Argument arg_ignoreOrder = parser.createParameter(IGNORE_ORDER, LinkedList.class, false);
        ParamUtil.Argument arg_exclude = parser.createParameter(EXCLUDE, LinkedList.class, false);
        boolean res = parser.parse(this.getParameter());
        assert (res) : "Malformed HashAnnotator parameter string. See documentation for details!";
        try {
            List feats;
            this.localPositionAnnotationKey = (String)arg_localPos.getValue();
            this.referencedObjectsPositionAnnotationKey = (String)arg_refPos.getValue();
            this.allowGlobalMove = (Boolean)arg_globalMove.getValue();
            if (arg_ignoreOrder.getValue() != null) {
                for (Object featureName : (LinkedList)arg_ignoreOrder.getValue()) {
                    assert (featureName instanceof String) : "Malformed HashAnnotator parameter string. See documentation for details!";
                    List refs = EMFMetaAccess.getEStructuralFeaturesByRegEx((EClass)acceptedType, (String)((String)featureName), (boolean)true);
                    assert (refs.size() >= 1) : "No valid feature found: " + featureName;
                    for (EStructuralFeature eStructuralFeature : refs) {
                        assert (eStructuralFeature instanceof EReference) : "No valid reference type: " + eStructuralFeature.getName();
                        assert (eStructuralFeature.isOrdered()) : "ignore order parameter only makes sense for ordered reference types";
                        this.ignoreOrder.add((EReference)eStructuralFeature);
                    }
                }
            }
            if (arg_exclude.getValue() != null) {
                for (Object featureName : (LinkedList)arg_exclude.getValue()) {
                    assert (featureName instanceof String) : "Malformed HashAnnotator parameter string. See documentation for details!";
                    feats = EMFMetaAccess.getEStructuralFeaturesByRegEx((EClass)acceptedType, (String)((String)featureName), (boolean)true);
                    assert (feats.size() >= 1) : "No valid feature found: " + featureName;
                    for (EStructuralFeature eStructuralFeature : feats) {
                        assert (this.checkExcludeConstraint(eStructuralFeature)) : featureName + " must no be a containment reference. These should be handled by suppressChildren parameter";
                        this.excludes.add(eStructuralFeature);
                    }
                }
            }
            if (arg_suppressChildren.getValue() != null) {
                for (Object featureName : (LinkedList)arg_exclude.getValue()) {
                    assert (featureName instanceof String) : "Malformed HashAnnotator parameter string. See documentation for details!";
                    feats = EMFMetaAccess.getEStructuralFeaturesByRegEx((EClass)acceptedType, (String)((String)featureName), (boolean)true);
                    assert (feats.size() >= 1) : "No valid feature found: " + featureName;
                    for (EStructuralFeature eStructuralFeature : feats) {
                        assert (eStructuralFeature instanceof EReference) : featureName + " must be a reference";
                        EReference ref = (EReference)eStructuralFeature;
                        assert (ref.isContainment()) : featureName + " must be a containment reference";
                        this.suppressedChildren.add(ref);
                    }
                }
            }
            assert (this.checkGlobalMoveParamConstraint()) : "globalMove is not allowed, so we need a localPositionAnnotationKey!";
            assert (this.checkUseRequiredConstraint()) : "There are used Keys that are not declared as required!";
        }
        catch (ParamUtil.UnparsedParameterStringException unparsedParameterStringException) {}
        try {
            this.md = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SiDiffRuntimeException(new Object[]{"Unknown hashing algorithm SHA", e});
        }
    }

    protected Object computeAnnotationValue(EObject object) {
        AnnotateableElement annotateable = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)object, AnnotateableElement.class);
        this.md.reset();
        this.md.update(object.eClass().getName().getBytes());
        if (!this.allowGlobalMove) {
            this.md.update(((String)annotateable.getAnnotation(this.localPositionAnnotationKey, String.class)).getBytes());
        }
        this.hashAttributes(object);
        List childrenRefs = EMFMetaAccess.getChildrenReferences((EClass)object.eClass());
        for (EReference eReference : childrenRefs) {
            if (this.suppressedChildren.contains(eReference)) continue;
            this.hashReferencedObjects(object, EMFMetaAccess.getChildrenReferences((EClass)object.eClass()), HASH_ANNOTATION_KEY);
        }
        if (this.referencedObjectsPositionAnnotationKey != null) {
            this.hashReferencedObjects(object, EMFMetaAccess.getReferences((EClass)object.eClass(), (EdgeSemantic)EdgeSemantic.Outgoing), this.referencedObjectsPositionAnnotationKey);
        }
        return this.getCurrentHashValue();
    }

    private String getCurrentHashValue() {
        StringBuffer buf = new StringBuffer();
        byte[] digest = this.md.digest();
        int i = 0;
        while (i < digest.length) {
            buf.append(Integer.toHexString(digest[i] & 0xFF));
            ++i;
        }
        return buf.toString();
    }

    private void hashAttributes(EObject object) {
        ArrayList attributes = new ArrayList(object.eClass().getEAllAttributes());
        Collections.sort(attributes, EMFComparators.ATTRIBUTE_BY_NAME);
        for (EAttribute attrib : attributes) {
            if (attrib.isID() || attrib.getEAnnotation(NO_HASH_ECORE_ANNOTATION) != null || this.excludes.contains(attrib)) continue;
            this.md.update(attrib.getName().getBytes());
            try {
                this.md.update(("" + object.eGet((EStructuralFeature)attrib)).getBytes());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
    }

    private void hashReferencedObjects(EObject object, List<EReference> references, String annotationKey) {
        ArrayList<EReference> sortedRefs = new ArrayList<EReference>(references);
        Collections.sort(sortedRefs, EMFComparators.REFERENCE_BY_NAME);
        for (EReference reference : sortedRefs) {
            if (reference.getEAnnotation(NO_HASH_ECORE_ANNOTATION) != null || this.excludes.contains(reference) || reference.getEType().getName().matches(".*To.*Map")) continue;
            ArrayList targets = new ArrayList();
            EMFUtil.fillObjectListFromReference(targets, (EObject)object, (EReference)reference);
            if (!reference.isOrdered() || this.ignoreOrder.contains(reference)) {
                assert (this.referencedObjectsPositionAnnotationKey != null) : "Reference '" + reference.getName() + "' is either unordered or its order shall be ignored, so the HashAnnotator needs parameter referencedObjectsAnnotationKey for class '" + this.getType().getName() + "' to be specified";
                Collections.sort(targets, EMFComparators.createObjectByAnnotationComparator((String)this.referencedObjectsPositionAnnotationKey));
            }
            for (EObject target : targets) {
                this.md.update(reference.getName().getBytes());
                AnnotateableElement annoTarget = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)target, AnnotateableElement.class);
                String anno = (String)annoTarget.getAnnotation(annotationKey, String.class);
                if (anno == null) {
                    anno = EMFUtil.getEObjectURI((EObject)target);
                }
                this.md.update(anno.getBytes());
            }
        }
    }

    private boolean checkExcludeConstraint(EStructuralFeature feature) {
        if (feature instanceof EReference) {
            return !((EReference)feature).isContainment();
        }
        return true;
    }

    private boolean checkGlobalMoveParamConstraint() {
        if (!this.allowGlobalMove) {
            return this.localPositionAnnotationKey != null;
        }
        return true;
    }

    private boolean checkUseRequiredConstraint() {
        boolean result = true;
        result &= this.localPositionAnnotationKey == null || this.getRequiredAnnotations().contains(this.localPositionAnnotationKey);
        return result &= this.referencedObjectsPositionAnnotationKey == null || this.getRequiredAnnotations().contains(this.referencedObjectsPositionAnnotationKey);
    }
}

