/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotators;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.sidiff.common.emf.access.EMFMetaAccess;
import org.sidiff.common.emf.access.EMFModelAccess;
import org.sidiff.common.emf.access.value.RemoteAttribute;
import org.sidiff.core.annotation.Annotator;

public class DerivedSignatureAnnotator
extends Annotator {
    private static final String VIRTUAL_TYPE_ATTRIBUTE = "{type}";
    public static final String DEFAULT_DERIVED_ID_ANNOTATION_KEY = "DERIVED_SIG";
    private static final String REMOTE_LOCAL_PART_SEPERATOR = "::";
    private static final String REMOTE_ITEM_SEPERATOR = "\\?";
    private static final String LOCAL_ITEM_SEPERATOR = ",";
    private final List<RemoteAttribute> valueDescriptors = new LinkedList<RemoteAttribute>();
    private final List<EAttribute> localAttributes = new LinkedList<EAttribute>();

    public DerivedSignatureAnnotator(EPackage documentType, String annotationKey, String parameter, EClass acceptedType, Collection<String> requiredAnnotations) {
        super(documentType, annotationKey, parameter, acceptedType, requiredAnnotations, Annotator.ExecutionOrder.PRE);
        if (parameter == null || parameter.equals("")) {
            throw new IllegalArgumentException("Parameter needed!");
        }
        if (parameter.startsWith(REMOTE_LOCAL_PART_SEPERATOR)) {
            this.fillLocalAttributes(parameter.replace(REMOTE_LOCAL_PART_SEPERATOR, "").split(LOCAL_ITEM_SEPERATOR));
        } else if (parameter.contains(REMOTE_LOCAL_PART_SEPERATOR)) {
            this.fillLocalAttributes(parameter.split(REMOTE_LOCAL_PART_SEPERATOR)[1].split(LOCAL_ITEM_SEPERATOR));
            this.fillRemoteAttributes(parameter.split(REMOTE_LOCAL_PART_SEPERATOR)[0].split(REMOTE_ITEM_SEPERATOR));
        } else {
            this.fillRemoteAttributes(parameter.split(REMOTE_ITEM_SEPERATOR));
        }
    }

    private void fillLocalAttributes(String[] localAttributeNames) {
        String[] stringArray = localAttributeNames;
        int n = localAttributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String localAttribute = stringArray[n2];
            if (!localAttribute.equals(VIRTUAL_TYPE_ATTRIBUTE)) {
                EStructuralFeature feature = this.getType().getEStructuralFeature(localAttribute.trim());
                if (feature != null && feature instanceof EAttribute) {
                    this.localAttributes.add((EAttribute)feature);
                } else {
                    throw new IllegalArgumentException("Syntax Error in Local Expression:" + localAttribute);
                }
            }
            ++n2;
        }
    }

    private void fillRemoteAttributes(String[] remoteExpressions) {
        String[] stringArray = remoteExpressions;
        int n = remoteExpressions.length;
        int n2 = 0;
        while (n2 < n) {
            String remoteExpression = stringArray[n2];
            remoteExpression = remoteExpression.replaceAll("\\s", "");
            this.valueDescriptors.add(EMFMetaAccess.translateRemoteAttribute((EClass)this.getType(), (String)remoteExpression));
            ++n2;
        }
    }

    protected Object computeAnnotationValue(EObject object) {
        assert (this.getType().isSuperTypeOf(object.eClass())) : "Invalid argument (" + object + ") Invalid Object (wrong type)!" + this.getType().getName() + "/" + object.eClass().getName();
        StringBuffer buffer = new StringBuffer();
        if (this.valueDescriptors.isEmpty() && this.localAttributes.isEmpty()) {
            throw new IllegalArgumentException("valueDescriptors and localAttributes are empty");
        }
        if (!this.valueDescriptors.isEmpty()) {
            Object remoteValue = null;
            Iterator<RemoteAttribute> descriptors = this.valueDescriptors.iterator();
            while (descriptors.hasNext()) {
                remoteValue = EMFModelAccess.computeRemoteAttributeValue((EObject)object, (RemoteAttribute)descriptors.next());
                buffer.append(remoteValue);
                if (!descriptors.hasNext()) continue;
                buffer.append(":");
            }
        }
        if (this.localAttributes.size() > 0) {
            if (!buffer.toString().isEmpty()) {
                buffer.append("/");
            }
            Iterator<EAttribute> iterator = this.localAttributes.iterator();
            while (iterator.hasNext()) {
                EAttribute localAttribute = iterator.next();
                buffer.append(object.eGet((EStructuralFeature)localAttribute));
                if (!iterator.hasNext()) continue;
                buffer.append(LOCAL_ITEM_SEPERATOR);
            }
        }
        return buffer.toString();
    }
}

