/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotators;

import java.util.Collection;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.core.annotators.AbstractPathAnnotator;

public class AttributePathAnnotator
extends AbstractPathAnnotator {
    private EAttribute eAttribute = null;

    public AttributePathAnnotator(EPackage documentType, String annotationKey, String parameter, EClass acceptedType, Collection<String> requiredAnnotations) {
        super(documentType, annotationKey, parameter, acceptedType, requiredAnnotations);
        EStructuralFeature feature = acceptedType.getEStructuralFeature(this.getParameter());
        if (feature == null || !(feature instanceof EAttribute)) {
            throw new IllegalAccessError(String.valueOf(acceptedType.getName()) + " does not contain a Attribute named '" + this.getParameter() + "'");
        }
        this.eAttribute = (EAttribute)feature;
    }

    @Override
    protected String getPathSegment(EObject object) {
        Object attrValue = object.eGet((EStructuralFeature)this.eAttribute);
        if (attrValue != null) {
            return attrValue.toString();
        }
        if (this.eAttribute.isRequired()) {
            throw new IllegalAccessError("Value of required attribute " + this.eAttribute.getName() + " is null for object " + object);
        }
        LogUtil.log((LogEvent)LogEvent.WARNING, (Object[])new Object[]{"Value of attribute " + this.eAttribute.getName() + " is null for object " + object + ". Returning <null> for path segment"});
        return "<null>";
    }
}

