/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotators;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.sidiff.common.emf.EMFUtil;
import org.sidiff.common.emf.access.EMFModelAccess;
import org.sidiff.core.annotation.Annotator;

public class Count2StepNeighbourTypes
extends Annotator {
    private String firstReferenceString;
    private String secondReferenceString;
    private String classString;

    public Count2StepNeighbourTypes(EPackage documentType, String annotationKey, String parameter, EClass acceptedType, Collection<String> requiredAnnotations) {
        super(documentType, annotationKey, parameter, acceptedType, requiredAnnotations, Annotator.ExecutionOrder.PRE);
        StringTokenizer st = new StringTokenizer(parameter, ",");
        this.firstReferenceString = st.nextToken();
        this.secondReferenceString = st.nextToken();
        this.classString = st.nextToken();
    }

    protected Object computeAnnotationValue(EObject object) {
        float answer = 0.0f;
        EReference firstReference = (EReference)object.eClass().getEStructuralFeature(this.firstReferenceString);
        List firstStep = EMFModelAccess.getNodeNeighbors((EObject)object, (EReference[])new EReference[]{firstReference});
        for (EObject obj : firstStep) {
            EReference secondReference = (EReference)obj.eClass().getEStructuralFeature(this.secondReferenceString);
            List secondStep = EMFModelAccess.getNodeNeighbors((EObject)obj, (EReference[])new EReference[]{secondReference});
            for (EObject obj2 : secondStep) {
                if (!EMFUtil.getModelRelativeName((EClassifier)obj2.eClass()).equals(this.classString)) continue;
                answer += 1.0f;
            }
        }
        return new Float(answer);
    }
}

