/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotation.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.sidiff.common.emf.access.tree.TreeVisitor;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.core.annotation.Annotator;

public class AnnotationVisitor
implements TreeVisitor {
    private Map<EClass, Collection<Annotator>> pre = null;
    private Map<EClass, Collection<Annotator>> post = null;
    private Set<String> keySet = null;
    private Map<String, Map<EClass, Annotator>> configuration = null;

    public AnnotationVisitor(Map<String, Map<EClass, Annotator>> configuration, Set<String> keys) {
        this.keySet = keys;
        this.configuration = configuration;
        this.pre = new HashMap<EClass, Collection<Annotator>>();
        this.post = new HashMap<EClass, Collection<Annotator>>();
    }

    private Collection<Annotator> lookup(EClass eClass) {
        LinkedList<Annotator> pre4class = new LinkedList<Annotator>();
        LinkedList<Annotator> post4class = new LinkedList<Annotator>();
        for (String key : this.keySet) {
            Map<EClass, Annotator> annotators4key = this.configuration.get(key);
            Annotator annotator = annotators4key.get(eClass);
            if (annotator == null) {
                Object superClasses = eClass.getESuperTypes();
                while (!superClasses.isEmpty()) {
                    HashSet superSuperClasses = new HashSet();
                    for (EClass superClass : superClasses) {
                        annotator = annotators4key.get(superClass);
                        if (annotator != null) break;
                        superSuperClasses.addAll(superClass.getESuperTypes());
                    }
                    superClasses = superSuperClasses;
                    if (annotator != null) break;
                }
            }
            if (annotator == null) {
                annotator = annotators4key.get(EcorePackage.eINSTANCE.getEObject());
            }
            if (annotator != null) {
                if (annotator.getOrder() == Annotator.ExecutionOrder.PRE) {
                    pre4class.add(annotator);
                    continue;
                }
                post4class.add(annotator);
                continue;
            }
            assert (LogUtil.log((LogEvent)LogEvent.DEBUG, (Object[])new Object[]{"Class " + eClass.getName() + " cannot be annotated with " + key + " (missing annotator)"}));
        }
        this.post.put(eClass, post4class);
        this.pre.put(eClass, pre4class);
        return pre4class;
    }

    public void postExecute(EObject object) {
        assert (this.post.get(object.eClass()) != null) : "Internal Error - Precondition Fail";
        Collection<Annotator> annotators = this.post.get(object.eClass());
        for (Annotator annotator : annotators) {
            annotator.annotate(object);
        }
    }

    public boolean preExecute(EObject object) {
        Collection<Annotator> annotators = this.pre.get(object.eClass());
        if (annotators == null) {
            annotators = this.lookup(object.eClass());
        }
        for (Annotator annotator : annotators) {
            annotator.annotate(object);
        }
        return true;
    }
}

