/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotation.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.sidiff.common.emf.EMFAdapter;
import org.sidiff.common.emf.access.EMFModelAccess;
import org.sidiff.common.emf.access.tree.TreeVisitor;
import org.sidiff.common.emf.annotation.AnnotateableElement;
import org.sidiff.common.exceptions.SiDiffRuntimeException;
import org.sidiff.common.io.IOUtil;
import org.sidiff.common.xml.XMLParser;
import org.sidiff.core.annotation.AnnotationService;
import org.sidiff.core.annotation.Annotator;
import org.sidiff.core.annotation.impl.AnnotationConfigurationContentHandler;
import org.sidiff.core.annotation.impl.AnnotationException;
import org.sidiff.core.annotation.impl.AnnotationVisitor;
import org.sidiff.core.annotation.impl.RemoveAnnotationVisitor;
import org.xml.sax.ContentHandler;

public class AnnotationServiceImpl
implements AnnotationService {
    public static final String EXECUTED_ANNOATIONS = "org.sidiff.core.annotation.Annotator.executedAnnotations";
    private Map<String, Map<EClass, Annotator>> annotators = new TreeMap<String, Map<EClass, Annotator>>();
    private Map<String, Set<String>> keyDependencies = new TreeMap<String, Set<String>>();

    @Override
    public void annotate(Resource model) {
        assert (model != null) : "Missing model (null)";
        this.internal_annotate(model, this.keyDependencies.keySet());
    }

    @Override
    public void removeAnnotations(Resource model) {
        assert (model != null) : "Missing model (null)";
        this.internal_remove(model, this.keyDependencies.keySet());
    }

    @Override
    public void annotate(Resource model, Set<String> keySet) {
        if (!this.keyDependencies.keySet().containsAll(keySet)) {
            throw new AnnotationException("Set contains non configured key!" + keySet);
        }
        this.internal_annotate(model, this.computeTransitiveClosure(keySet));
    }

    @Override
    public void removeAnnotations(Resource model, Set<String> keySet) {
        if (!this.keyDependencies.keySet().containsAll(keySet)) {
            throw new AnnotationException("Set contains non configured key!" + keySet);
        }
        this.internal_remove(model, keySet);
    }

    @Override
    public void annotate(Resource model, String key) {
        if (!this.keyDependencies.containsKey(key)) {
            throw new IllegalArgumentException("Unknown annotation key " + key);
        }
        this.annotate(model, Collections.singleton(key));
    }

    @Override
    public void removeAnnotations(Resource model, String key) {
        assert (model != null && key != null) : "Required model/key (null)";
        if (this.keyDependencies.containsKey(key)) {
            this.internal_remove(model, Collections.singleton(key));
        }
    }

    @Override
    public Set<String> availableKeys() {
        return this.keyDependencies.keySet();
    }

    @Override
    public Set<String> executedKeys(Resource model) {
        AnnotateableElement aobject = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)model, AnnotateableElement.class);
        return Collections.unmodifiableSet((Set)aobject.getOrCreateAnnotation(EXECUTED_ANNOATIONS, HashSet.class));
    }

    public String configure(Object ... configData) {
        if (configData.length == 1 && configData[0] instanceof String) {
            String configDataString = (String)configData[0];
            if (configDataString.endsWith(".xml")) {
                AnnotationConfigurationContentHandler acch = new AnnotationConfigurationContentHandler();
                XMLParser.parseStream((InputStream)IOUtil.getInputStream((String)configDataString), (ContentHandler)acch);
                this.configureAnnotators(acch.getAnnotators());
                return acch.getDocumentType();
            }
            configDataString.endsWith(".annotation");
        }
        throw new SiDiffRuntimeException(new Object[]{"Invalid Configuration data. Need exactly one parameter (the file string of the annotation configuration file), but got the following config. data: ", configData});
    }

    public Dictionary<String, String> getProperties() {
        return null;
    }

    public void deconfigure() {
        this.annotators.clear();
        this.keyDependencies.clear();
    }

    private void configureAnnotators(Collection<Annotator> annotators) {
        assert (annotators != null) : "Nothing to configure (null)";
        for (Annotator annotator : annotators) {
            String key = annotator.getAnnotationKey();
            Map<EClass, Annotator> annotators4key = this.annotators.get(key);
            if (annotators4key == null) {
                annotators4key = new HashMap<EClass, Annotator>();
                this.annotators.put(key, annotators4key);
            }
            if (annotators4key.containsKey(annotator.getType())) {
                throw new IllegalArgumentException("Invalid Configuration! Duplicate entry for key " + key + " of type " + annotator.getType().getName());
            }
            annotators4key.put(annotator.getType(), annotator);
            Set<String> dependencies = this.keyDependencies.get(key);
            if (dependencies == null) {
                dependencies = new HashSet<String>();
                this.keyDependencies.put(key, dependencies);
            }
            dependencies.addAll(annotator.getRequiredAnnotations());
        }
        this.computeTransitiveClosure(this.keyDependencies.keySet());
    }

    private Set<String> computeTransitiveClosure(Set<String> keys) {
        HashSet<String> closure = new HashSet<String>();
        for (String key : keys) {
            this.computeTransitiveClosure(key, closure, new HashSet<String>());
            closure.add(key);
        }
        return closure;
    }

    private Set<String> computeTransitiveClosure(String key, Set<String> closure, Set<String> visited) {
        if (this.keyDependencies.containsKey(key) && !visited.contains(key)) {
            visited.add(key);
            closure.add(key);
            Collection dependencies = this.keyDependencies.get(key);
            for (String dependency : dependencies) {
                if (closure.contains(dependency)) continue;
                this.computeTransitiveClosure(dependency, closure, visited);
            }
        } else {
            throw new AnnotationException("Unaccomplishable key '" + key + "' (non provided requirement or cycle)");
        }
        visited.remove(key);
        return closure;
    }

    private void internal_annotate(Resource model, Set<String> keys) {
        AnnotateableElement aobject = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)model, AnnotateableElement.class);
        Set providedKeys = (Set)aobject.getOrCreateAnnotation(EXECUTED_ANNOATIONS, HashSet.class);
        HashSet<String> openKeys = new HashSet<String>(keys);
        openKeys.removeAll(providedKeys);
        while (!openKeys.isEmpty()) {
            Set<String> executeable = this.computeExecuteableKeys(openKeys, providedKeys);
            if (!executeable.isEmpty()) {
                AnnotationVisitor visitor = new AnnotationVisitor(this.annotators, executeable);
                openKeys.removeAll(executeable);
                EMFModelAccess.traverse((Resource)model, (TreeVisitor)visitor);
                providedKeys.addAll(executeable);
                continue;
            }
            throw new AnnotationException("No more executable Keys '", openKeys, "'");
        }
    }

    private void internal_remove(Resource model, Set<String> keys) {
        AnnotateableElement aobject = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)model, AnnotateableElement.class);
        Set computedKeys = (Set)aobject.getOrCreateAnnotation(EXECUTED_ANNOATIONS, HashSet.class);
        HashSet<String> keysToRemove = new HashSet<String>(keys);
        keysToRemove.retainAll(computedKeys);
        computedKeys.removeAll(keysToRemove);
        Set<String> partition = this.computeTransitiveClosure(computedKeys);
        if (!computedKeys.containsAll(partition)) {
            partition.removeAll(computedKeys);
            throw new AnnotationException("Revokation of '", keys, "' breaks dependencies:", partition);
        }
        RemoveAnnotationVisitor remove = new RemoveAnnotationVisitor(keysToRemove);
        EMFModelAccess.traverse((Resource)model, (TreeVisitor)remove);
    }

    private Set<String> computeExecuteableKeys(Set<String> openKeys, Set<String> providedKeys) {
        HashSet<String> executeable = new HashSet<String>();
        for (String key : openKeys) {
            if (!providedKeys.containsAll((Collection)this.keyDependencies.get(key))) continue;
            executeable.add(key);
        }
        return executeable;
    }
}

