/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.sidiff.common.emf.access.EMFMetaAccess;
import org.sidiff.common.emf.exceptions.UnknownDocumentTypeException;
import org.sidiff.common.exceptions.SiDiffRuntimeException;
import org.sidiff.common.util.ReflectionUtil;
import org.sidiff.core.annotation.Annotator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class AnnotationConfigurationContentHandler
implements ContentHandler {
    private static final String OPERATION_PREFIX = "org.sidiff.core.annotators";
    private static final String SEPERATOR = ",";
    private static final String ELEM_ANNOTATIONS = "Annotations";
    private static final String ATT_DOCTYPE = "documentType";
    private static final String ELEM_ANNOTATION = "Annotation";
    private static final String ATT_NODETYPE = "nodeType";
    private static final String ELEM_SYNTH_ATTR = "SyntheticAttribute";
    private static final String ATT_SA_OPERATION = "operation";
    private static final String ATT_SA_NAME = "attributeName";
    private static final String ATT_SA_PARAMETER = "parameter";
    private static final String ATT_SA_REQUIRES = "requires";
    private ArrayList<Annotator> annotators;
    private EPackage documentType;
    private EClassifier currentClassifier = null;

    public ArrayList<Annotator> getAnnotators() {
        return this.annotators;
    }

    public String getDocumentType() {
        return this.documentType.getNsURI();
    }

    @Override
    public void startDocument() throws SAXException {
        this.annotators = new ArrayList();
        this.documentType = null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase(ELEM_ANNOTATIONS)) {
            this.processGlobalSettings(atts);
        } else if (localName.equalsIgnoreCase(ELEM_ANNOTATION)) {
            this.prepareAnnotation(atts);
        } else if (localName.equalsIgnoreCase(ELEM_SYNTH_ATTR)) {
            this.processAttribute(atts);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equalsIgnoreCase(ELEM_ANNOTATION)) {
            this.finishAnnotation();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareAnnotation(Attributes atts) {
        String currentClassifierName = atts.getValue(ATT_NODETYPE);
        if (currentClassifierName == null || "".equals(currentClassifierName)) return;
        EClassifier classifier = EMFMetaAccess.getMetaObjectByName((String)this.documentType.getNsURI(), (String)currentClassifierName);
        if (classifier == null) {
            if (!currentClassifierName.equals("EObject")) throw new SiDiffRuntimeException(new Object[]{"Illegal classifier " + currentClassifierName});
            this.currentClassifier = EcorePackage.eINSTANCE.getEObject();
            return;
        } else {
            this.currentClassifier = classifier;
        }
    }

    private void processAttribute(Attributes atts) {
        List requiredAttributes;
        String attributeName = atts.getValue(ATT_SA_NAME);
        String className = atts.getValue(ATT_SA_OPERATION);
        String parameter = atts.getValue(ATT_SA_PARAMETER);
        String requires = atts.getValue(ATT_SA_REQUIRES);
        if (attributeName != null && !"".equals(attributeName) && className != null && !"".equals(className)) {
            requiredAttributes = null;
            if (requires != null && !"".equalsIgnoreCase(requires)) {
                requiredAttributes = new ArrayList();
                String[] stringArray = requires.split(SEPERATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String attribute = stringArray[n2];
                    if (!requiredAttributes.add(attribute)) {
                        throw new SiDiffRuntimeException(new Object[]{"Duplicate required Attribute! " + attribute});
                    }
                    ++n2;
                }
            } else {
                requiredAttributes = Collections.emptyList();
            }
            if (className.indexOf(".") == -1) {
                className = "org.sidiff.core.annotators." + className;
            }
        } else {
            throw new SiDiffRuntimeException(new Object[]{this, "Synthetic Attribute must have attributes 'attributeName' and 'operation'!"});
        }
        this.annotators.add((Annotator)ReflectionUtil.createInstance((String)className, Annotator.class, (Object[])new Object[]{this.documentType, attributeName, parameter, this.currentClassifier, requiredAttributes}));
    }

    private void processGlobalSettings(Attributes atts) {
        String documentType = atts.getValue(ATT_DOCTYPE);
        if (documentType != null && !"".equalsIgnoreCase(documentType)) {
            if (EPackage.Registry.INSTANCE.getEPackage(documentType) == null) {
                throw new UnknownDocumentTypeException(new Object[]{"Document type unknown ", documentType});
            }
        } else {
            throw new SiDiffRuntimeException(new Object[]{"Missing Documenttype!"});
        }
        this.documentType = EPackage.Registry.INSTANCE.getEPackage(documentType);
    }

    private void finishAnnotation() {
        this.currentClassifier = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

