/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.core.annotation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.sidiff.common.emf.EMFAdapter;
import org.sidiff.common.emf.annotation.AnnotateableElement;

public abstract class Annotator {
    private String annotationKey = null;
    private String parameter = null;
    private EClass acceptedType = null;
    private ExecutionOrder order = null;
    private EPackage documentType = null;
    private List<String> requiredAnnotations = new LinkedList<String>();

    protected Annotator(EPackage documentType, String annotationKey, String parameter, EClass acceptedType, Collection<String> requiredAnnotations, ExecutionOrder order) {
        assert (documentType != null) : "Missing documenttype!";
        assert (acceptedType != null) : "Don't know what to be accepted!";
        assert (order != null) : "Don't know my execution order!";
        assert (annotationKey != null && !annotationKey.equals("")) : "Don't know what to annotate";
        this.documentType = documentType;
        this.annotationKey = annotationKey;
        this.order = order;
        this.acceptedType = acceptedType;
        this.parameter = parameter;
        if (requiredAnnotations != null) {
            this.requiredAnnotations.addAll(requiredAnnotations);
        }
        this.requiredAnnotations = Collections.unmodifiableList(this.requiredAnnotations);
    }

    public String getAnnotationKey() {
        return this.annotationKey;
    }

    public EClass getType() {
        return this.acceptedType;
    }

    public String getParameter() {
        return this.parameter;
    }

    public Collection<String> getRequiredAnnotations() {
        return Collections.unmodifiableList(this.requiredAnnotations);
    }

    public ExecutionOrder getOrder() {
        return this.order;
    }

    public EPackage getDocumentType() {
        return this.documentType;
    }

    public void annotate(EObject object) {
        if (!this.acceptedType.isSuperTypeOf(object.eClass()) && this.acceptedType != EcorePackage.eINSTANCE.getEObject()) {
            throw new IllegalArgumentException("Cannot process object of type " + object.eClass().getName());
        }
        AnnotateableElement annotateable = (AnnotateableElement)EMFAdapter.INSTANCE.adapt((Notifier)object, AnnotateableElement.class);
        Object value = this.computeAnnotationValue(object);
        annotateable.setAnnotation(this.annotationKey, value);
    }

    protected abstract Object computeAnnotationValue(EObject var1);

    protected static Collection<String> addAdditionalRequirements(Collection<String> requiredAnnotations, String ... additionalRequirements) {
        LinkedList<String> requirements = new LinkedList<String>(requiredAnnotations);
        String[] stringArray = additionalRequirements;
        int n = additionalRequirements.length;
        int n2 = 0;
        while (n2 < n) {
            String additionalRequirement = stringArray[n2];
            requirements.add(additionalRequirement);
            ++n2;
        }
        return requirements;
    }

    public static enum ExecutionOrder {
        PRE,
        POST;

    }
}

