/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.common.emf.extensions.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.sidiff.common.emf.access.EMFMetaAccess;
import org.sidiff.common.emf.extensions.impl.ContainmentCycleDetector;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;

public class EClassifierInfoManagement {
    private HashMap<EClassifier, EClassifierInfo> eClassifierInfoMap = new HashMap();
    private HashMap<EClassifier, Set<EClassifier>> abstractToConcreteEClassifierMap = new HashMap();
    private HashMap<EClassifier, List<EClassifier>> subTypeMap = new HashMap();
    private Set<EClassifier> profileStereotypesSet = new HashSet<EClassifier>();
    private Set<EClassifier> profileMetaclassSet = new HashSet<EClassifier>();
    private static EClassifierInfoManagement instance = null;
    private Boolean stereotypeMapping = false;

    public static EClassifierInfoManagement getInstance() {
        if (instance == null) {
            instance = new EClassifierInfoManagement();
        }
        return instance;
    }

    private EClassifierInfoManagement() {
    }

    public void gatherInformation(Boolean enableStereotypeMapping, Stack<EPackage> ePackagesStack, Boolean enableInnerContainmentCycleDetection) {
        EPackage[] ePackageArray = new EPackage[ePackagesStack.size()];
        ePackagesStack.toArray(ePackageArray);
        this.gatherSubtypeHierarchy(ePackageArray);
        this.mapConcreteEClassifiersToAbstractSuperTypes(ePackagesStack);
        this.gatherAllEClassifierInfos(ePackagesStack);
        ContainmentCycleDetector ccDetector = new ContainmentCycleDetector(enableInnerContainmentCycleDetection);
        ccDetector.detectContainmentCycles(ePackagesStack);
    }

    @Deprecated
    public static EClassifierInfoManagement getInstance(Boolean enableStereotypeMapping, Stack<EPackage> ePackagesStack) {
        if (instance == null) {
            instance = new EClassifierInfoManagement(enableStereotypeMapping, ePackagesStack);
        }
        return instance;
    }

    @Deprecated
    private EClassifierInfoManagement(Boolean enableStereotypeMapping, Stack<EPackage> ePackagesStack) {
        this.stereotypeMapping = enableStereotypeMapping;
        EPackage[] ePackageArray = new EPackage[ePackagesStack.size()];
        ePackagesStack.toArray(ePackageArray);
        this.gatherSubtypeHierarchy(ePackageArray);
        this.mapConcreteEClassifiersToAbstractSuperTypes(ePackagesStack);
        this.gatherAllEClassifierInfos(ePackagesStack);
    }

    private void gatherSubtypeHierarchy(EPackage[] ePackages) {
        EPackage[] ePackageArray = ePackages;
        int n = ePackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                ArrayList subtypes = new ArrayList();
                subtypes.addAll(EMFMetaAccess.getAllSubclasses((EClass)eClass, (EPackage[])ePackages));
                this.subTypeMap.put(eClassifier, subtypes);
            }
            ++n2;
        }
    }

    public void mapConcreteEClassifiersToAbstractSuperTypes(Stack<EPackage> ePackagesStack) {
        EClass eClass;
        for (EPackage ePackage : ePackagesStack) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || !(eClass = (EClass)eClassifier).isAbstract()) continue;
                HashSet concreteEClasses = new HashSet();
                this.abstractToConcreteEClassifierMap.put(eClassifier, concreteEClasses);
            }
        }
        for (EPackage ePackage : ePackagesStack) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                for (EClassifier abstractEClassifier : this.abstractToConcreteEClassifierMap.keySet()) {
                    EClass abstractEClass;
                    if (!(abstractEClassifier instanceof EClass) || !(abstractEClass = (EClass)abstractEClassifier).isSuperTypeOf(eClass)) continue;
                    this.abstractToConcreteEClassifierMap.get(abstractEClassifier).add(eClassifier);
                }
            }
        }
    }

    public void gatherAllEClassifierInfos(Stack<EPackage> ePackagesStack) {
        for (EPackage ePackage : ePackagesStack) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClassifierInfo eClassifierInfo = this.getEClassifierInfo(eClassifier);
                if (this.stereotypeMapping.booleanValue()) {
                    this.findAndMapStereotypes(eClassifierInfo);
                }
                if (eClassifier instanceof EClass) {
                    EClass eClass = (EClass)eClassifier;
                    for (EReference eRef : eClass.getEAllReferences()) {
                        if (eRef.isDerived()) continue;
                        Set<EClassifier> mC = EClassifierInfoManagement.findMandatoryChild(eRef);
                        Set<EClassifier> oC = EClassifierInfoManagement.findOptionalChild(eRef);
                        Set<EClassifier> mN = this.findMandatoryNeighbour(eRef);
                        Set<EClassifier> oN = this.findOptionalNeighbour(eRef);
                        Set<EClassifier> mPC = this.findMandatoryParentContext(eRef);
                        Set<EClassifier> oPC = this.findOptionalParentContext(eRef);
                        Set<EClassifier> mNC = this.findMandatoryNeighbourContext(eRef);
                        Set<EClassifier> oNC = this.findOptionalNeighbourContext(eRef);
                        mC = this.addSubtypes(mC);
                        oC = this.addSubtypes(oC);
                        oN = this.addSubtypes(oN);
                        oN = this.addSubtypes(oN);
                        mPC = this.addSubtypes(mPC);
                        oPC = this.addSubtypes(oPC);
                        mNC = this.addSubtypes(mNC);
                        oNC = this.addSubtypes(oNC);
                        if (mC != null) {
                            for (EClassifier child : mC) {
                                this.add_MC_to_parent(eClassifier, child, eRef);
                                this.add_MPC_to_Child(child, eClassifier, eRef);
                                for (EClassifier subtypeOfParent : this.subTypeMap.get(eClassifier)) {
                                    this.add_MPC_to_Child(child, subtypeOfParent, eRef);
                                    this.add_MC_to_parent(subtypeOfParent, child, eRef);
                                }
                            }
                        }
                        if (oC != null) {
                            for (EClassifier child : oC) {
                                this.add_OC_to_parent(eClassifier, child, eRef);
                                this.add_OPC_to_Child(child, eClassifier, eRef);
                                for (EClassifier subtypeOfParent : this.subTypeMap.get(eClassifier)) {
                                    this.add_OPC_to_Child(child, subtypeOfParent, eRef);
                                    this.add_OC_to_parent(subtypeOfParent, child, eRef);
                                }
                            }
                        }
                        if (mN != null) {
                            for (EClassifier neighbour : mN) {
                                this.add_MN_to_Neighbour(eClassifier, neighbour, eRef);
                                this.add_MNC_to_Neighbour(neighbour, eClassifier, eRef);
                                for (EClassifier subtypeOfEClassifierNeighbour : this.subTypeMap.get(eClassifier)) {
                                    this.add_MNC_to_Neighbour(neighbour, subtypeOfEClassifierNeighbour, eRef);
                                    this.add_MN_to_Neighbour(subtypeOfEClassifierNeighbour, neighbour, eRef);
                                }
                            }
                        }
                        if (oN != null) {
                            for (EClassifier neighbour : oN) {
                                this.add_ON_to_Neighbour(eClassifier, neighbour, eRef);
                                this.add_ONC_to_Neighbour(neighbour, eClassifier, eRef);
                                for (EClassifier subtypeOfEClassifierNeighbour : this.subTypeMap.get(eClassifier)) {
                                    this.add_ONC_to_Neighbour(neighbour, subtypeOfEClassifierNeighbour, eRef);
                                    this.add_ON_to_Neighbour(subtypeOfEClassifierNeighbour, neighbour, eRef);
                                }
                            }
                        }
                        if (mPC != null) {
                            for (EClassifier p : mPC) {
                                this.add_MPC_to_Child(eClassifier, p, eRef.getEOpposite());
                            }
                        }
                        if (oPC != null) {
                            for (EClassifier p : oPC) {
                                this.add_OPC_to_Child(eClassifier, p, eRef.getEOpposite());
                            }
                        }
                        if (mNC != null) {
                            for (EClassifier n : mNC) {
                                this.add_MNC_to_Neighbour(eClassifier, n, eRef.getEOpposite());
                            }
                        }
                        if (oNC == null) continue;
                        for (EClassifier n : oNC) {
                            this.add_ONC_to_Neighbour(eClassifier, n, eRef.getEOpposite());
                        }
                    }
                }
                this.eClassifierInfoMap.put(eClassifier, eClassifierInfo);
            }
        }
    }

    private Set<EClassifier> addSubtypes(Set<EClassifier> existingSet) {
        if (existingSet == null) {
            return null;
        }
        HashSet<EClassifier> newSet = new HashSet<EClassifier>();
        for (EClassifier exCl : existingSet) {
            List<EClassifier> subtypes = this.subTypeMap.get(exCl);
            if (subtypes == null) continue;
            newSet.addAll(subtypes);
        }
        existingSet.addAll(newSet);
        return existingSet;
    }

    public EClassifierInfo getEClassifierInfo(EClassifier eClassifier) {
        if (this.eClassifierInfoMap.get(eClassifier) == null) {
            this.eClassifierInfoMap.put(eClassifier, new EClassifierInfo(eClassifier));
        }
        return this.eClassifierInfoMap.get(eClassifier);
    }

    public ArrayList<EClassifier> getAllConcreteEClassifiersForAbstract(EClassifier eClassifier) {
        ArrayList<EClassifier> concreteEClasses = new ArrayList<EClassifier>();
        for (EClassifier abstractEClassifier : this.abstractToConcreteEClassifierMap.keySet()) {
            if (!abstractEClassifier.equals(eClassifier)) continue;
            for (EClassifier replacement : this.abstractToConcreteEClassifierMap.get(abstractEClassifier)) {
                if (!(replacement instanceof EClass)) continue;
                EClass replacementEClass = (EClass)replacement;
                if (replacementEClass.isAbstract()) {
                    concreteEClasses = this.getAllConcreteEClassifiersForAbstract(replacement);
                    continue;
                }
                concreteEClasses.add(replacement);
            }
        }
        return concreteEClasses;
    }

    public HashMap<EReference, List<EClassifier>> getAllOptionalParentContext(EClassifier eClassifier, Boolean preferSuperTypes) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getEClassifierInfo(eClassifier).getOptionalParentContext());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getEAllSuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo(superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getOptionalParentContext());
            }
        }
        if (preferSuperTypes.booleanValue()) {
            for (Map.Entry entry : map.entrySet()) {
                EReference eRef = (EReference)entry.getKey();
                ((List)entry.getValue()).clear();
                ((List)entry.getValue()).add(eRef.getEContainingClass());
            }
        }
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllMandatoryParentContext(EClassifier eClassifier, Boolean preferSuperTypes) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getEClassifierInfo(eClassifier).getMandatoryParentContext());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getEAllSuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo(superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getMandatoryParentContext());
            }
        }
        if (preferSuperTypes.booleanValue()) {
            for (Map.Entry entry : map.entrySet()) {
                EReference eRef = (EReference)entry.getKey();
                ((List)entry.getValue()).clear();
                ((List)entry.getValue()).add(eRef.getEContainingClass());
            }
        }
        return map;
    }

    public boolean hasMultipleOccurences(EClassifier context, HashMap<EReference, List<EClassifier>> map) {
        int count = 0;
        for (Map.Entry<EReference, List<EClassifier>> entry : map.entrySet()) {
            List<EClassifier> contexts = entry.getValue();
            for (EClassifier currentContext : contexts) {
                if (!currentContext.equals(context)) continue;
                ++count;
            }
        }
        return count > 1;
    }

    public HashMap<EReference, List<EClassifier>> getAllOptionalNeighbourContext(EClassifier eClassifier) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getEClassifierInfo(eClassifier).getOptionalNeighbourContext());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getESuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo(superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getOptionalNeighbourContext());
            }
        }
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllMandatoryNeighbourContext(EClassifier eClassifier) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getEClassifierInfo(eClassifier).getMandatoryNeighbourContext());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getESuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo(superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getMandatoryNeighbourContext());
            }
        }
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllNeighbourContexts(EClassifier eClassifier) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getAllOptionalNeighbourContext(eClassifier));
        map.putAll(this.getAllMandatoryNeighbourContext(eClassifier));
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllParentContexts(EClassifier eClassifier, Boolean preferSuperTypes) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        map.putAll(this.getAllOptionalParentContext(eClassifier, preferSuperTypes));
        map.putAll(this.getAllMandatoryParentContext(eClassifier, preferSuperTypes));
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllChildren(EClassifier eClassifier) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        EClassifierInfo eClassInfo = this.getEClassifierInfo(eClassifier);
        map.putAll(eClassInfo.getOptionalChildren());
        map.putAll(eClassInfo.getMandatoryChildren());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClass superType : eClass.getESuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo((EClassifier)superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getOptionalChildren());
                map.putAll(infoOfSuperType.getMandatoryChildren());
            }
        }
        return map;
    }

    public HashMap<EReference, List<EClassifier>> getAllNeighbours(EClassifier eClassifier) {
        HashMap<EReference, List<EClassifier>> map = new HashMap<EReference, List<EClassifier>>();
        EClassifierInfo eClassInfo = this.getEClassifierInfo(eClassifier);
        map.putAll(eClassInfo.getOptionalNeighbours());
        map.putAll(eClassInfo.getMandatoryNeighbours());
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getESuperTypes()) {
                EClassifierInfo infoOfSuperType = this.getEClassifierInfo(superType);
                if (infoOfSuperType == null) continue;
                map.putAll(infoOfSuperType.getOptionalNeighbours());
                map.putAll(infoOfSuperType.getMandatoryNeighbours());
            }
        }
        return map;
    }

    public Set<EClassifierInfo> getAllSubTypes(EClassifierInfo eInfo) {
        HashSet<EClassifierInfo> set = new HashSet<EClassifierInfo>();
        for (EClassifier subType : this.subTypeMap.get(eInfo.getTheEClassifier())) {
            EClassifierInfo subEInfo = this.getEClassifierInfo(subType);
            set.add(subEInfo);
            set.addAll(this.getAllSubTypes(subEInfo));
        }
        return set;
    }

    public Set<EClassifier> getAllSubTypes(EClassifier eClassifier) {
        HashSet<EClassifier> set = new HashSet<EClassifier>();
        for (EClassifier subType : this.subTypeMap.get(eClassifier)) {
            set.add(subType);
            set.addAll(this.getAllSubTypes(subType));
        }
        return set;
    }

    public Set<EClassifier> getAllSubTypesAsEClassifiersWithoutAbstracts(EClassifier eClassifier) {
        HashSet<EClassifier> set = new HashSet<EClassifier>();
        for (EClassifier subType : this.subTypeMap.get(eClassifier)) {
            if (subType instanceof EClassifier && !((EClass)subType).isAbstract()) {
                set.add(subType);
            }
            set.addAll(this.getAllSubTypesAsEClassifiersWithoutAbstracts(subType));
        }
        return set;
    }

    public Set<EClassifier> getAllStereotypes(EClassifier eClassifier) {
        HashSet<EClassifier> connectedStereotypes = new HashSet<EClassifier>();
        EClassifierInfo eInfo = this.getEClassifierInfo(eClassifier);
        connectedStereotypes.addAll(eInfo.getStereotypes());
        block0: for (EClassifier stereotype : this.profileStereotypesSet) {
            EList stereoSupertypes = stereotype.eClass().getEAllSuperTypes();
            for (EClassifier supertype : stereoSupertypes) {
                if (!connectedStereotypes.contains(supertype)) continue;
                connectedStereotypes.add(stereotype);
                continue block0;
            }
        }
        return connectedStereotypes;
    }

    public List<EAttribute> getAllInheritedEAttributesInvolvedInConstraints(EClassifier eClassifier) {
        ArrayList<EAttribute> additionalEAsToConsider = new ArrayList<EAttribute>();
        if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            for (EClassifier superType : eClass.getEAllSuperTypes()) {
                EAttribute additional;
                EClassifierInfo supInfo = this.getEClassifierInfo(superType);
                Boolean applicationOnSubTypesSet = null;
                if (supInfo == null) continue;
                if (supInfo.isConstrainedToGlobalNameUniqueness() && (applicationOnSubTypesSet = (Boolean)supInfo.getConstraintsAndFlags().get((Object)EClassifierInfo.ConstraintType.NAME_UNIQUENESS_GLOBAL).get(0)).booleanValue() && !additionalEAsToConsider.contains(additional = (EAttribute)supInfo.getConstraintsAndFlags().get((Object)EClassifierInfo.ConstraintType.NAME_UNIQUENESS_GLOBAL).get(1))) {
                    additionalEAsToConsider.add(additional);
                }
                if (!supInfo.isConstrainedToLocalNameUniqueness() || !(applicationOnSubTypesSet = (Boolean)supInfo.getConstraintsAndFlags().get((Object)EClassifierInfo.ConstraintType.NAME_UNIQUENESS_LOCAL).get(0)).booleanValue() || additionalEAsToConsider.contains(additional = (EAttribute)supInfo.getConstraintsAndFlags().get((Object)EClassifierInfo.ConstraintType.NAME_UNIQUENESS_LOCAL).get(1))) continue;
                additionalEAsToConsider.add(additional);
            }
        }
        return additionalEAsToConsider;
    }

    public Set<EClassifier> getAllProfileStereotypes() {
        return this.profileStereotypesSet;
    }

    public Set<EClassifier> getAllProfileMetaClasses() {
        return this.profileMetaclassSet;
    }

    public boolean hasAbstractMandatoryChildren(EClassifierInfo eClassInfo) {
        for (EClassifier child : eClassInfo.getMandatoryChildren().values().iterator().next()) {
            if (!this.abstractToConcreteEClassifierMap.containsKey(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAbstractMandatoryNeighbours(EClassifierInfo eClassInfo) {
        for (EClassifier neighbour : eClassInfo.getMandatoryNeighbours().values().iterator().next()) {
            if (!this.abstractToConcreteEClassifierMap.containsKey(neighbour)) continue;
            return true;
        }
        return false;
    }

    public EClassifier getEClassifierByName(String name) {
        for (EClassifier eClassifier : this.eClassifierInfoMap.keySet()) {
            if (!eClassifier.getName().equals(name)) continue;
            return eClassifier;
        }
        return null;
    }

    public void addConstraint(EClassifierInfo.ConstraintType ctype, EClassifier eClassifier, List<Object> flags) {
        EClassifierInfo eInfo = this.eClassifierInfoMap.get(eClassifier);
        eInfo.addConstraint(ctype, flags);
        if (((Boolean)flags.get(0)).booleanValue()) {
            for (EClassifierInfo subEInfo : this.getAllSubTypes(eInfo)) {
                subEInfo.addConstraint(ctype, flags);
            }
        }
    }

    private static Set<EClassifier> findMandatoryChild(EReference eRef) {
        if (eRef.isContainment() && eRef.getLowerBound() > 0) {
            EClassifier mC = eRef.getEType();
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(mC);
            return hs;
        }
        return null;
    }

    private static Set<EClassifier> findOptionalChild(EReference eRef) {
        if (eRef.isContainment() && (eRef.getUpperBound() - eRef.getLowerBound() > 0 || eRef.getUpperBound() == -1)) {
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(eRef.getEType());
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findMandatoryNeighbour(EReference eRef) {
        if (!eRef.isContainment() && eRef.getLowerBound() > 0) {
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(eRef.getEType());
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findOptionalNeighbour(EReference eRef) {
        EReference eOpposite = eRef.getEOpposite();
        EClassifier oN = null;
        if (!eRef.isContainment() && eOpposite != null) {
            if (!(eOpposite.isContainment() || eRef.getUpperBound() - eRef.getLowerBound() <= 0 && eRef.getUpperBound() != -1)) {
                oN = eRef.getEType();
                if (oN instanceof EClass && ((EClass)oN).isAbstract()) {
                    return this.abstractToConcreteEClassifierMap.get(oN);
                }
                HashSet<EClassifier> hs = new HashSet<EClassifier>();
                hs.add(oN);
                return hs;
            }
        } else if (!(eRef.isContainment() || eOpposite != null || eRef.getUpperBound() - eRef.getLowerBound() <= 0 && eRef.getUpperBound() != -1)) {
            oN = eRef.getEType();
            if (oN instanceof EClass && ((EClass)oN).isAbstract()) {
                return this.abstractToConcreteEClassifierMap.get(oN);
            }
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(oN);
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findMandatoryParentContext(EReference eRef) {
        EReference eOpposite = eRef.getEOpposite();
        EClassifier mPC = null;
        if (eOpposite != null && eOpposite.isContainment() && eOpposite.getLowerBound() > 0) {
            mPC = eRef.getEType();
            if (mPC instanceof EClass && ((EClass)mPC).isAbstract()) {
                return this.abstractToConcreteEClassifierMap.get(mPC);
            }
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(mPC);
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findOptionalParentContext(EReference eRef) {
        EReference eOpposite = eRef.getEOpposite();
        EClassifier oPC = null;
        if (eOpposite != null && eOpposite.isContainment() && (eOpposite.getUpperBound() - eOpposite.getLowerBound() > 0 || eOpposite.getUpperBound() == -1)) {
            oPC = eRef.getEType();
            if (oPC instanceof EClass && ((EClass)oPC).isAbstract()) {
                return this.abstractToConcreteEClassifierMap.get(oPC);
            }
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(oPC);
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findOptionalNeighbourContext(EReference eRef) {
        EReference eOpposite = eRef.getEOpposite();
        EClassifier oNC = null;
        if (eOpposite != null && (eOpposite.isContainment() || eRef.isContainment())) {
            return null;
        }
        if (!(eOpposite == null || eOpposite.isContainment() || eOpposite.getUpperBound() - eOpposite.getLowerBound() <= 0 && eOpposite.getUpperBound() != -1)) {
            oNC = eRef.getEType();
            if (oNC instanceof EClass && ((EClass)oNC).isAbstract()) {
                return this.abstractToConcreteEClassifierMap.get(oNC);
            }
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(oNC);
            return hs;
        }
        return null;
    }

    private Set<EClassifier> findMandatoryNeighbourContext(EReference eRef) {
        EReference eOpposite = eRef.getEOpposite();
        EClassifier mNC = null;
        if (eOpposite != null && !eOpposite.isContainment() && eOpposite.getLowerBound() > 0) {
            mNC = eRef.getEType();
            if (mNC instanceof EClass && ((EClass)mNC).isAbstract()) {
                return this.abstractToConcreteEClassifierMap.get(mNC);
            }
            HashSet<EClassifier> hs = new HashSet<EClassifier>();
            hs.add(mNC);
            return hs;
        }
        return null;
    }

    private void add_MPC_to_Child(EClassifier child, EClassifier parent, EReference parentRef) {
        EClassifierInfo eClassInfo = this.getEClassifierInfo(child);
        if (eClassInfo.getMandatoryParentContext().get(parentRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(parent);
            eClassInfo.getMandatoryParentContext().put(parentRef, list);
        } else if (!eClassInfo.getMandatoryParentContext().get(parentRef).contains(parent)) {
            eClassInfo.getMandatoryParentContext().get(parentRef).add(parent);
        }
    }

    private void add_OPC_to_Child(EClassifier child, EClassifier parent, EReference parentRef) {
        EClassifierInfo eClassInfo = this.getEClassifierInfo(child);
        if (eClassInfo.getOptionalParentContext().get(parentRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(parent);
            eClassInfo.getOptionalParentContext().put(parentRef, list);
        } else if (!eClassInfo.getOptionalParentContext().get(parentRef).contains(parent)) {
            eClassInfo.getOptionalParentContext().get(parentRef).add(parent);
        }
    }

    private void add_OC_to_parent(EClassifier parent, EClassifier child, EReference eRef) {
        EClassifierInfo parentInfo = this.getEClassifierInfo(parent);
        if (parentInfo.getOptionalChildren().get(eRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(child);
            parentInfo.getOptionalChildren().put(eRef, list);
        } else if (!parentInfo.getOptionalChildren().get(eRef).contains(child)) {
            parentInfo.getOptionalChildren().get(eRef).add(child);
        }
    }

    private void add_MC_to_parent(EClassifier parent, EClassifier child, EReference eRef) {
        EClassifierInfo parentInfo = this.getEClassifierInfo(parent);
        if (parentInfo.getMandatoryChildren().get(eRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(child);
            parentInfo.getMandatoryChildren().put(eRef, list);
        } else if (!parentInfo.getMandatoryChildren().get(eRef).contains(child)) {
            parentInfo.getMandatoryChildren().get(eRef).add(child);
        }
    }

    private void add_ON_to_Neighbour(EClassifier fromNeighbourContext, EClassifier toOptionalNeighbour, EReference directedRef) {
        EClassifierInfo fromNeighbourInfo = this.getEClassifierInfo(fromNeighbourContext);
        if (fromNeighbourInfo.getOptionalNeighbours().get(directedRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(toOptionalNeighbour);
            fromNeighbourInfo.getOptionalNeighbours().put(directedRef, list);
        } else if (!fromNeighbourInfo.getOptionalNeighbours().get(directedRef).contains(toOptionalNeighbour)) {
            fromNeighbourInfo.getOptionalNeighbours().get(directedRef).add(toOptionalNeighbour);
        }
    }

    private void add_MN_to_Neighbour(EClassifier fromNeighbourContext, EClassifier toMandatoryNeighbour, EReference directedRef) {
        EClassifierInfo fromNeighbourInfo = this.getEClassifierInfo(fromNeighbourContext);
        if (fromNeighbourInfo.getMandatoryNeighbours().get(directedRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(toMandatoryNeighbour);
            fromNeighbourInfo.getMandatoryNeighbours().put(directedRef, list);
        } else if (!fromNeighbourInfo.getMandatoryNeighbours().get(directedRef).contains(toMandatoryNeighbour)) {
            fromNeighbourInfo.getMandatoryNeighbours().get(directedRef).add(toMandatoryNeighbour);
        }
    }

    private void add_MNC_to_Neighbour(EClassifier toNeighbour, EClassifier fromNeighbour, EReference directedRef) {
        EClassifierInfo eClassInfo = this.getEClassifierInfo(toNeighbour);
        if (eClassInfo.getMandatoryNeighbourContext().get(directedRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(fromNeighbour);
            eClassInfo.getMandatoryNeighbourContext().put(directedRef, list);
        } else if (!eClassInfo.getMandatoryNeighbourContext().get(directedRef).contains(fromNeighbour)) {
            eClassInfo.getMandatoryNeighbourContext().get(directedRef).add(fromNeighbour);
        }
    }

    private void add_ONC_to_Neighbour(EClassifier toNeighbour, EClassifier fromNeighbour, EReference directedRef) {
        EClassifierInfo eClassInfo = this.getEClassifierInfo(toNeighbour);
        if (eClassInfo.getOptionalNeighbourContext().get(directedRef) == null) {
            ArrayList<EClassifier> list = new ArrayList<EClassifier>();
            list.add(fromNeighbour);
            eClassInfo.getOptionalNeighbourContext().put(directedRef, list);
        } else if (!eClassInfo.getOptionalNeighbourContext().get(directedRef).contains(fromNeighbour)) {
            eClassInfo.getOptionalNeighbourContext().get(directedRef).add(fromNeighbour);
        }
    }

    private void findAndMapStereotypes(EClassifierInfo eClassifierInfo) {
        EClass eClass;
        EClassifier eClassifier = eClassifierInfo.getTheEClassifier();
        EClass eClass2 = eClass = eClassifier instanceof EClass ? (EClass)eClassifier : null;
        if (eClass != null) {
            List featureList = EMFMetaAccess.getEStructuralFeaturesByRegEx((EClass)eClass, (String)"^(base)_\\w+", (boolean)true);
            for (EStructuralFeature extension : featureList) {
                EClassifier metaClass = extension.getEType();
                eClassifierInfo.addExtendedMetaClass(metaClass);
                EClassifierInfo eClassInfoOfMetaClass = this.getEClassifierInfo(metaClass);
                if (eClassInfoOfMetaClass == null) {
                    eClassInfoOfMetaClass = new EClassifierInfo(metaClass);
                    this.eClassifierInfoMap.put(metaClass, eClassInfoOfMetaClass);
                }
                eClassInfoOfMetaClass.addStereotype(eClassifier);
                this.profileMetaclassSet.add(metaClass);
                this.profileStereotypesSet.add(eClassifier);
            }
        }
    }
}

