/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.common.emf.extensions.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.sidiff.common.emf.extensions.impl.ContainmentCycle;
import org.sidiff.common.emf.extensions.impl.Mask;

public class EClassifierInfo {
    private EClassifier theEClassifier = null;
    private HashMap<EReference, List<EClassifier>> mandatoryChildren = new HashMap();
    private HashMap<EReference, List<EClassifier>> mandatoryNeighbours = new HashMap();
    private HashMap<EReference, List<EClassifier>> mandatoryParentContext = new HashMap();
    private HashMap<EReference, List<EClassifier>> mandatoryNeighbourContext = new HashMap();
    private HashMap<EReference, List<EClassifier>> optionalChildren = new HashMap();
    private HashMap<EReference, List<EClassifier>> optionalNeighbours = new HashMap();
    private HashMap<EReference, List<EClassifier>> optionalParentContext = new HashMap();
    private HashMap<EReference, List<EClassifier>> optionalNeighbourContext = new HashMap();
    private ArrayList<EClassifier> stereotypes = new ArrayList();
    private ArrayList<EClassifier> extendedMetaClasses = new ArrayList();
    private Set<ContainmentCycle> containmentCycles = new HashSet<ContainmentCycle>();
    private List<Mask> masks = new ArrayList<Mask>();
    private HashMap<ConstraintType, List<Object>> appliedConstraints = new HashMap();

    public EClassifierInfo(EClassifier eClassifier) {
        this.theEClassifier = eClassifier;
    }

    public HashMap<EReference, List<EClassifier>> getMandatoryChildren() {
        return this.mandatoryChildren;
    }

    public HashMap<EReference, List<EClassifier>> getMandatoryNeighbours() {
        return this.mandatoryNeighbours;
    }

    public HashMap<EReference, List<EClassifier>> getMandatoryParentContext() {
        return this.mandatoryParentContext;
    }

    public HashMap<EReference, List<EClassifier>> getMandatoryNeighbourContext() {
        return this.mandatoryNeighbourContext;
    }

    public HashMap<EReference, List<EClassifier>> getOptionalChildren() {
        return this.optionalChildren;
    }

    public HashMap<EReference, List<EClassifier>> getOptionalNeighbours() {
        return this.optionalNeighbours;
    }

    public HashMap<EReference, List<EClassifier>> getOptionalParentContext() {
        return this.optionalParentContext;
    }

    public HashMap<EReference, List<EClassifier>> getOptionalNeighbourContext() {
        return this.optionalNeighbourContext;
    }

    public EClassifier getTheEClassifier() {
        return this.theEClassifier;
    }

    public ArrayList<EClassifier> getStereotypes() {
        return this.stereotypes;
    }

    public ArrayList<EClassifier> getExtendedMetaClasses() {
        return this.extendedMetaClasses;
    }

    public HashMap<ConstraintType, List<Object>> getConstraintsAndFlags() {
        return this.appliedConstraints;
    }

    public List<Mask> getMasks() {
        return this.masks;
    }

    public Set<ContainmentCycle> getContainmentCycles() {
        return this.containmentCycles;
    }

    public void addExtendedMetaClass(EClassifier extendedMetaClass) {
        if (!this.extendedMetaClasses.contains(extendedMetaClass)) {
            this.extendedMetaClasses.add(extendedMetaClass);
        }
    }

    public void addStereotype(EClassifier stereotype) {
        if (!this.stereotypes.contains(stereotype)) {
            this.stereotypes.add(stereotype);
        }
    }

    public void addConstraint(ConstraintType ctype, List<Object> flags) {
        this.appliedConstraints.put(ctype, flags);
    }

    public void addMask(Mask mask) {
        if (!this.masks.contains(mask)) {
            this.masks.add(mask);
        }
    }

    public void addContainmentCycle(ContainmentCycle cc) {
        this.containmentCycles.add(cc);
    }

    public HashMap<EReference, List<EClassifier>> getAllDirectChildren(EClassifier childEClassifier) {
        HashMap<EReference, List<EClassifier>> allDirectChildren = new HashMap<EReference, List<EClassifier>>();
        allDirectChildren.putAll(this.getMandatoryChildren());
        allDirectChildren.putAll(this.getOptionalChildren());
        return allDirectChildren;
    }

    public HashSet<EClassifier> getClassifiersOfAttributesForEClassifier(EClassifier eClassifier) {
        HashSet<EClassifier> attributeClassifiers = new HashSet<EClassifier>();
        for (EAttribute eAttribute : eClassifier.eClass().getEAllAttributes()) {
            attributeClassifiers.add(eAttribute.getEType());
        }
        return attributeClassifiers;
    }

    public HashSet<EClassifier> getAllMandatoryClassifiers() {
        HashSet<EClassifier> mandatoryClassifiers = new HashSet<EClassifier>();
        for (EReference ref : this.getMandatoryChildren().keySet()) {
            for (EClassifier classifier : this.getMandatoryChildren().get(ref)) {
                if (mandatoryClassifiers.contains(classifier)) continue;
                mandatoryClassifiers.add(classifier);
            }
        }
        for (EReference ref : this.getMandatoryNeighbours().keySet()) {
            for (EClassifier classifier : this.getMandatoryNeighbours().get(ref)) {
                if (mandatoryClassifiers.contains(classifier)) continue;
                mandatoryClassifiers.add(classifier);
            }
        }
        for (EReference ref : this.getMandatoryNeighbourContext().keySet()) {
            for (EClassifier classifier : this.getMandatoryNeighbourContext().get(ref)) {
                if (mandatoryClassifiers.contains(classifier)) continue;
                mandatoryClassifiers.add(classifier);
            }
        }
        for (EReference ref : this.getMandatoryParentContext().keySet()) {
            for (EClassifier classifier : this.getMandatoryParentContext().get(ref)) {
                if (mandatoryClassifiers.contains(classifier)) continue;
                mandatoryClassifiers.add(classifier);
            }
        }
        mandatoryClassifiers.addAll(this.getClassifiersOfAttributesForEClassifier(this.theEClassifier));
        return mandatoryClassifiers;
    }

    public boolean selfMayHaveTransformations() {
        return !this.optionalParentContext.isEmpty() || !this.optionalNeighbourContext.isEmpty() || this.mandatoryParentContext.isEmpty() && this.mandatoryNeighbourContext.isEmpty();
    }

    public boolean hasMandatories() {
        return !this.mandatoryChildren.isEmpty() || !this.mandatoryNeighbours.isEmpty();
    }

    public boolean hasMasks() {
        return !this.masks.isEmpty();
    }

    public boolean isStereotype() {
        return this.stereotypes.isEmpty();
    }

    public boolean isExtendedMetaClass() {
        return this.extendedMetaClasses.isEmpty();
    }

    public boolean isConstrainedToLocalNameUniqueness() {
        return this.appliedConstraints.get((Object)ConstraintType.NAME_UNIQUENESS_LOCAL) != null;
    }

    public boolean isConstrainedToGlobalNameUniqueness() {
        return this.appliedConstraints.get((Object)ConstraintType.NAME_UNIQUENESS_GLOBAL) != null;
    }

    public boolean isOnlyConstrainedToGlobalNameUniqueness() {
        return this.appliedConstraints.get((Object)ConstraintType.NAME_UNIQUENESS_LOCAL) == null && this.appliedConstraints.get((Object)ConstraintType.NAME_UNIQUENESS_GLOBAL) != null;
    }

    public HashMap<EReference, List<EClassifier>> getMandatoryContexts() {
        HashMap<EReference, List<EClassifier>> mandatoryContexts = new HashMap<EReference, List<EClassifier>>();
        mandatoryContexts.putAll(this.getMandatoryParentContext());
        mandatoryContexts.putAll(this.getMandatoryNeighbourContext());
        return mandatoryContexts;
    }

    public static enum ConstraintType {
        NAME_UNIQUENESS_LOCAL,
        NAME_UNIQUENESS_GLOBAL;

    }

    public static enum Map {
        MANDATORY_CHILDREN,
        MANDATORY_NEIGHBOURS,
        MANDATORY_PARENT_CONTEXT,
        OPTIONAL_CHILDREN,
        OPTIONAL_NEIGHBOURS,
        OPTIONAL_PARENT_CONTEXT,
        OPTIONAL_NEIGHBOUR_CONTEXT;

    }
}

