/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.common.emf.extensions.impl;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.sidiff.common.emf.extensions.impl.ContainmentCycle;
import org.sidiff.common.emf.extensions.impl.ContainmentCyclePathStep;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;

public class ContainmentCycleDetector {
    private EClassifierInfoManagement ECM = EClassifierInfoManagement.getInstance();
    private Boolean considerInnerContainmentCycles;

    public ContainmentCycleDetector(Boolean considerInnerContainmentCycles) {
        this.considerInnerContainmentCycles = considerInnerContainmentCycles;
    }

    public ContainmentCycle detectContainmentCycles(Stack<EPackage> ePackagesStack) {
        for (EPackage ePackage : ePackagesStack) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                this.findCycles(eClass);
            }
        }
        return null;
    }

    private void findCycles(EClass eClass) {
        for (EReference eRef : eClass.getEAllReferences()) {
            if (!eRef.isContainment()) continue;
            EClass target = eRef.getEReferenceType();
            Stack<ContainmentCyclePathStep> path = new Stack<ContainmentCyclePathStep>();
            ContainmentCyclePathStep originPair = new ContainmentCyclePathStep(null, (EClassifier)eClass);
            path.push(originPair);
            if (this.checkTargetIsOriginOfPath(path, (EClassifier)target)) {
                ContainmentCycle cc = this.createAndStoreContainmentCycle(path, eRef, (EClassifier)target, false);
                this.logCC(cc);
                continue;
            }
            Stack<ContainmentCyclePathStep> backedUpPath = new Stack<ContainmentCyclePathStep>();
            backedUpPath.addAll(path);
            ContainmentCyclePathStep pDirectPair = new ContainmentCyclePathStep(eRef, (EClassifier)target);
            path.push(pDirectPair);
            this.findNextStep(path);
        }
    }

    private void findNextStep(Stack<ContainmentCyclePathStep> currentPath) {
        Stack<ContainmentCyclePathStep> backedUpPath = new Stack<ContainmentCyclePathStep>();
        backedUpPath.addAll(currentPath);
        ContainmentCyclePathStep lastEntry = (ContainmentCyclePathStep)currentPath.lastElement();
        EClassifier eClassifier = lastEntry.getTargetedEClassifier();
        Iterator refIterator = ((EClass)eClassifier).getEAllReferences().iterator();
        if (refIterator.hasNext()) {
            EReference firstRef = (EReference)refIterator.next();
            EClass targetOfFirstRef = firstRef.getEReferenceType();
            this.checkAndStoreCycles(currentPath, firstRef, (EClassifier)targetOfFirstRef);
            while (refIterator.hasNext()) {
                Stack<ContainmentCyclePathStep> copyOfInitialPath = new Stack<ContainmentCyclePathStep>();
                copyOfInitialPath.addAll(backedUpPath);
                EReference nextRef = (EReference)refIterator.next();
                if (!nextRef.isContainment()) continue;
                EClass targetOfNextRef = nextRef.getEReferenceType();
                this.checkAndStoreCycles(copyOfInitialPath, nextRef, (EClassifier)targetOfNextRef);
            }
        }
    }

    private void checkAndStoreCycles(Stack<ContainmentCyclePathStep> currentPath, EReference eRef, EClassifier eClassifier) {
        boolean producesOuterCycle = this.checkTargetIsOriginOfPath(currentPath, eClassifier);
        boolean producesInnerCycle = this.checkInnerCircle(currentPath, eClassifier);
        if (producesOuterCycle) {
            ContainmentCycle cc = this.createAndStoreContainmentCycle(currentPath, eRef, eClassifier, false);
            this.logCC(cc);
        } else if (this.considerInnerContainmentCycles.booleanValue() && producesInnerCycle) {
            ContainmentCycle cc = this.createAndStoreContainmentCycle(currentPath, eRef, eClassifier, true);
            this.logCC(cc);
        } else if (!(producesInnerCycle && !this.considerInnerContainmentCycles.booleanValue() || producesOuterCycle || producesInnerCycle || this.considerInnerContainmentCycles.booleanValue())) {
            Stack<ContainmentCyclePathStep> backedUpPath = new Stack<ContainmentCyclePathStep>();
            backedUpPath.addAll(currentPath);
            ContainmentCyclePathStep step = new ContainmentCyclePathStep(eRef, eClassifier);
            currentPath.push(step);
            this.findNextStep(currentPath);
        }
    }

    private boolean checkTargetIsOriginOfPath(Stack<ContainmentCyclePathStep> currentPath, EClassifier eClassifier) {
        EClass target = (EClass)eClassifier;
        EClass origin = (EClass)((ContainmentCyclePathStep)currentPath.firstElement()).getTargetedEClassifier();
        return target.equals(origin) || origin.getEAllSuperTypes().contains((Object)target);
    }

    private boolean checkInnerCircle(Stack<ContainmentCyclePathStep> currentPath, EClassifier eClassifier) {
        boolean alreadyContained = false;
        EClass target = (EClass)eClassifier;
        Iterator stepIt = currentPath.iterator();
        stepIt.next();
        while (stepIt.hasNext()) {
            ContainmentCyclePathStep step = (ContainmentCyclePathStep)stepIt.next();
            EClass stepTarget = (EClass)step.getTargetedEClassifier();
            if (!target.equals(stepTarget) && !stepTarget.getEAllSuperTypes().contains((Object)target)) continue;
            alreadyContained = true;
            break;
        }
        return alreadyContained;
    }

    private ContainmentCycle createAndStoreContainmentCycle(Stack<ContainmentCyclePathStep> path, EReference eRef, EClassifier eClassifier, Boolean isInnerCircle) {
        ContainmentCyclePathStep step = new ContainmentCyclePathStep(eRef, eClassifier);
        path.push(step);
        EClassifier firstConsideration = ((ContainmentCyclePathStep)path.get(0)).getTargetedEClassifier();
        ContainmentCycle cc = new ContainmentCycle(path, isInnerCircle);
        this.ECM.getEClassifierInfo(firstConsideration).addContainmentCycle(cc);
        return cc;
    }

    private void logCC(ContainmentCycle cc) {
        String message = "Found" + (cc.isInnerCircle() != false ? " (inner )" : "") + " Containment-Cycle ";
        message = String.valueOf(message) + cc.getPathAsString();
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{message});
    }
}

