/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.common.emf.extensions.impl;

import java.util.Stack;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.sidiff.common.emf.extensions.impl.ContainmentCyclePathStep;

public class ContainmentCycle {
    private Stack<ContainmentCyclePathStep> path = new Stack();
    private Boolean containsInnerCircle;

    public ContainmentCycle(Stack<ContainmentCyclePathStep> path, Boolean containsInnerCircle) {
        this.path = path;
        this.containsInnerCircle = containsInnerCircle;
    }

    public String getPathAsString() {
        String message = "";
        for (ContainmentCyclePathStep step : this.path) {
            EClassifier eClassifier = step.getTargetedEClassifier();
            EReference eRef = step.getTargetingReference();
            message = eRef == null ? String.valueOf(message) + "[" + eClassifier.getName() + "]" : String.valueOf(message) + " > (" + eRef.getName() + ")" + eClassifier.getName();
        }
        return message;
    }

    public Boolean isInnerCircle() {
        return this.containsInnerCircle;
    }

    public ContainmentCyclePathStep getStartingPoint() {
        return (ContainmentCyclePathStep)this.path.firstElement();
    }

    public ContainmentCyclePathStep getBackwardPointingStep() {
        return (ContainmentCyclePathStep)this.path.lastElement();
    }

    public Stack<ContainmentCyclePathStep> getIntermediateSteps() {
        Stack<ContainmentCyclePathStep> intermediates = new Stack<ContainmentCyclePathStep>();
        intermediates.addAll(this.path);
        intermediates.remove(this.path.firstElement());
        intermediates.remove(this.path.lastElement());
        return intermediates;
    }

    public Integer getNumberOfIntermediateSteps() {
        return this.getIntermediateSteps().size();
    }

    public Boolean isLastIntermediateStep(ContainmentCyclePathStep step) {
        int numberOfIntermediates = this.getNumberOfIntermediateSteps();
        ContainmentCyclePathStep lastIntermediate = (ContainmentCyclePathStep)this.getIntermediateSteps().get(numberOfIntermediates - 1);
        return lastIntermediate.equals(step);
    }
}

