/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.ui.widgets;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.sidiff.editrule.generator.IEditRuleGenerator;
import org.sidiff.editrule.generator.settings.EditRuleGenerationSettings;
import org.sidiff.editrule.generator.util.EditRuleGeneratorUtil;
import org.silift.common.util.ui.widgets.IWidget;
import org.silift.common.util.ui.widgets.IWidgetSelection;
import org.silift.common.util.ui.widgets.IWidgetValidation;

public class EditRuleGeneratorWidget
implements IWidget,
IWidgetSelection,
IWidgetValidation {
    protected EditRuleGenerationSettings settings;
    protected SortedMap<String, IEditRuleGenerator> generators;
    protected Composite container;
    protected List list_generators;

    public EditRuleGeneratorWidget() {
        this.getGenerators();
    }

    public Composite createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout grid = new GridLayout(1, false);
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        this.container.setLayout((Layout)grid);
        Label matchingLabel = new Label(this.container, 0);
        matchingLabel.setText("EditRule Generator:");
        this.list_generators = new List(this.container, 2564);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 70;
        this.list_generators.setLayoutData((Object)data);
        this.list_generators.setItems(this.generators.keySet().toArray(new String[0]));
        if (this.list_generators.getItems().length != 0) {
            this.list_generators.setSelection(0);
        } else {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Missing EditRule Generator", (String)"No EditRule generators are found!");
        }
        this.list_generators.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditRuleGeneratorWidget.this.settings.setGenerator(EditRuleGeneratorWidget.this.getSelection());
            }
        });
        this.settings.setGenerator(this.getSelection());
        return this.container;
    }

    public Composite getWidget() {
        return this.container;
    }

    public void setLayoutData(Object layoutData) {
        this.container.setLayoutData(layoutData);
    }

    protected void getGenerators() {
        this.generators = new TreeMap<String, IEditRuleGenerator>();
        Set matcherSet = EditRuleGeneratorUtil.getAvailableEditRuleGenerators();
        for (IEditRuleGenerator matcher : matcherSet) {
            this.generators.put(matcher.getName(), matcher);
        }
    }

    public IEditRuleGenerator getSelection() {
        return (IEditRuleGenerator)this.generators.get(this.list_generators.getSelection()[0]);
    }

    public SortedMap<String, IEditRuleGenerator> getGeneratorMap() {
        return this.generators;
    }

    public boolean validate() {
        return this.list_generators.getSelectionIndex() != -1;
    }

    public String getValidationMessage() {
        if (this.validate()) {
            return "";
        }
        return "Please select an EditRule generator";
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.list_generators == null) {
            throw new RuntimeException("Create controls first!");
        }
        this.list_generators.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.list_generators != null) {
            this.list_generators.removeSelectionListener(listener);
        }
    }

    public void setEnabled(Boolean enabled) {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled.booleanValue());
            ++n2;
        }
    }

    public EditRuleGenerationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(EditRuleGenerationSettings settings) {
        this.settings = settings;
    }

    public List getList_generators() {
        return this.list_generators;
    }

    public void setList_generators(List list_generators) {
        this.list_generators = list_generators;
    }
}

