/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.EReferenceInfo;
import org.sidiff.common.henshin.ApplicationCondition;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;

public class RuleExecutionChecker {
    private Rule rule;
    protected Map<Node, Map<EReference, Set<Edge>>> src2OutType2OutEdge;

    public RuleExecutionChecker(Rule rule) {
        this.rule = rule;
    }

    public boolean isExecutable() {
        this.buildSrc2OutIndex();
        for (Node src : this.src2OutType2OutEdge.keySet()) {
            Map<EReference, Set<Edge>> outType2Edge = this.src2OutType2OutEdge.get(src);
            for (EReference outType : outType2Edge.keySet()) {
                int sum_toBeMatched = 0;
                int sum_forbid = 0;
                for (Edge outEdge : outType2Edge.get(outType)) {
                    if (HenshinRuleAnalysisUtilEx.isDeletionEdge((Edge)outEdge) || HenshinRuleAnalysisUtilEx.isRequireEdge((Edge)outEdge) || HenshinRuleAnalysisUtilEx.isPreservedEdge((Edge)outEdge)) {
                        ++sum_toBeMatched;
                    }
                    if (HenshinRuleAnalysisUtilEx.isForbiddenEdge((Edge)outEdge)) {
                        ++sum_forbid;
                    }
                    if (EReferenceInfo.isBounded((EReference)outType) && sum_toBeMatched > outType.getUpperBound()) {
                        return false;
                    }
                    if (!EReferenceInfo.isRequired((EReference)outType) || sum_forbid <= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void buildSrc2OutIndex() {
        this.src2OutType2OutEdge = new HashMap<Node, Map<EReference, Set<Edge>>>();
        for (NodePair preservedNode : HenshinRuleAnalysisUtilEx.getPreservedNodes((Rule)this.rule)) {
            for (Edge edge : preservedNode.getLhsNode().getOutgoing()) {
                this.addEdge(preservedNode.getLhsNode(), edge);
            }
            for (Edge edge : preservedNode.getRhsNode().getOutgoing()) {
                this.addEdge(preservedNode.getLhsNode(), edge);
            }
            for (NestedCondition nc : this.rule.getLhs().getNestedConditions()) {
                ApplicationCondition condition = new ApplicationCondition(nc);
                Node acBoundaryNode = condition.getAcBoundaryNode(preservedNode.getLhsNode());
                if (acBoundaryNode == null) continue;
                for (Edge edge : acBoundaryNode.getOutgoing()) {
                    this.addEdge(preservedNode.getLhsNode(), edge);
                }
            }
        }
        for (Node deletionNode : HenshinRuleAnalysisUtilEx.getLHSMinusRHSNodes((Rule)this.rule)) {
            for (Edge edge : deletionNode.getOutgoing()) {
                this.addEdge(deletionNode, edge);
            }
        }
        for (Node creationNode : HenshinRuleAnalysisUtilEx.getRHSMinusLHSNodes((Rule)this.rule)) {
            for (Edge edge : creationNode.getOutgoing()) {
                this.addEdge(creationNode, edge);
            }
        }
    }

    private void addEdge(Node src, Edge edge) {
        if (this.src2OutType2OutEdge.get(src) == null) {
            this.src2OutType2OutEdge.put(src, new HashMap());
        }
        if (this.src2OutType2OutEdge.get(src).get(edge.getType()) == null) {
            this.src2OutType2OutEdge.get(src).put(edge.getType(), new HashSet());
        }
        this.src2OutType2OutEdge.get(src).get(edge.getType()).add(edge);
    }
}

