/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.conditions;

import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinConditionUtil;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.editrule.generator.serge.generators.conditions.AbstractBoundCheckGenerator;

public class LowerBoundCheckGenerator
extends AbstractBoundCheckGenerator {
    public LowerBoundCheckGenerator(Rule editRule) {
        super(editRule);
    }

    public void generate() {
        for (NodePair preservedNode : this.src2Out.keySet()) {
            Set outTypes = (Set)this.src2Out.get(preservedNode);
            for (EReference outType : outTypes) {
                int offset;
                int lb = outType.getLowerBound();
                int balance = this.getBalance(preservedNode, outType);
                int preserved = this.getPreservedCount(preservedNode, outType);
                if (lb <= 0 || balance >= 0 || preserved >= lb || (offset = lb - preserved + balance + 1) <= 0) continue;
                Formula formula = this.createBoundCheck(offset, preservedNode.getLhsNode(), outType, false);
                HenshinConditionUtil.addFormula((Formula)formula, (Graph)this.editRule.getLhs(), (HenshinRuleAnalysisUtilEx.FormulaCombineOperator)HenshinRuleAnalysisUtilEx.FormulaCombineOperator.AND);
            }
        }
    }
}

