/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.conditions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.editrule.generator.serge.generators.conditions.AbstractConditionGenerator;

public abstract class AbstractBoundCheckGenerator
extends AbstractConditionGenerator {
    protected Map<NodePair, Set<EReference>> src2Out;
    private int ubCounter;
    private int lbCounter;

    public AbstractBoundCheckGenerator(Rule editRule) {
        super(editRule);
        this.buildSrc2OutIndex();
        this.ubCounter = 0;
        this.lbCounter = 0;
    }

    private void buildSrc2OutIndex() {
        this.src2Out = new HashMap<NodePair, Set<EReference>>();
        for (NodePair preservedNode : HenshinRuleAnalysisUtilEx.getPreservedNodes((Rule)this.editRule)) {
            for (Edge edge : preservedNode.getLhsNode().getOutgoing()) {
                this.addEdgeType(preservedNode, edge.getType());
            }
            for (Edge edge : preservedNode.getRhsNode().getOutgoing()) {
                this.addEdgeType(preservedNode, edge.getType());
            }
        }
    }

    private void addEdgeType(NodePair key, EReference edgeType) {
        if (this.src2Out.get(key) == null) {
            this.src2Out.put(key, new HashSet());
        }
        this.src2Out.get(key).add(edgeType);
    }

    protected int getBalance(NodePair preservedNode, EReference edgeType) {
        int created = 0;
        int deleted = 0;
        for (Edge edge : preservedNode.getRhsNode().getOutgoing()) {
            if (!edge.getType().equals(edgeType) || !HenshinRuleAnalysisUtilEx.isCreationEdge((Edge)edge)) continue;
            ++created;
        }
        for (Edge edge : preservedNode.getLhsNode().getOutgoing()) {
            if (!edge.getType().equals(edgeType) || !HenshinRuleAnalysisUtilEx.isDeletionEdge((Edge)edge)) continue;
            ++deleted;
        }
        return created - deleted;
    }

    protected int getPreservedCount(NodePair preservedNode, EReference edgeType) {
        int res = 0;
        for (Edge edge : preservedNode.getLhsNode().getOutgoing()) {
            if (!edge.getType().equals(edgeType) || !HenshinRuleAnalysisUtilEx.isPreservedEdge((Edge)edge)) continue;
            ++res;
        }
        return res;
    }

    protected Formula createBoundCheck(int offset, Node lhsBoundaryNode, EReference edgeType, boolean invert) {
        NestedCondition cond = HenshinFactory.eINSTANCE.createNestedCondition();
        Graph graph = HenshinFactory.eINSTANCE.createGraph();
        if (invert) {
            graph.setName("ub" + this.ubCounter);
            ++this.ubCounter;
        } else {
            graph.setName("lb" + this.lbCounter);
            ++this.lbCounter;
        }
        cond.setConclusion(graph);
        Node acSrc = HenshinFactory.eINSTANCE.createNode(graph, lhsBoundaryNode.getType(), "");
        int i = 0;
        while (i < offset) {
            Node acTgt = HenshinFactory.eINSTANCE.createNode(graph, edgeType.getEReferenceType(), "");
            HenshinFactory.eINSTANCE.createEdge(acSrc, acTgt, edgeType);
            ++i;
        }
        Mapping mapping = HenshinFactory.eINSTANCE.createMapping(lhsBoundaryNode, acSrc);
        cond.getMappings().add((Object)mapping);
        if (invert) {
            Not res = HenshinFactory.eINSTANCE.createNot();
            res.setChild((Formula)cond);
            return res;
        }
        return cond;
    }
}

