/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class SetReferenceGenerator {
    private EReference eReference;
    private EClassifier contextEClassifier;
    private EClassifier target;
    private Configuration config = Configuration.getInstance();

    public SetReferenceGenerator(EReference eReference, EClassifier contextEClassifier, EClassifier target) {
        assert (!eReference.isContainment() && eReference.getLowerBound() == 0 && eReference.getUpperBound() == 1);
        this.eReference = eReference;
        this.contextEClassifier = contextEClassifier;
        this.target = target;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "SET_REFERENCE_" + this.contextEClassifier.getName() + "_(" + this.eReference.getName() + ")" + "_TGT_" + this.target.getName();
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating SET_REFERENCE : " + name});
        Module SET_REFERENCE_Module = HenshinFactory.eINSTANCE.createModule();
        SET_REFERENCE_Module.setName(name);
        SET_REFERENCE_Module.setDescription("Sets " + this.contextEClassifier.getName() + "'s reference " + this.eReference.getName() + " the target " + this.target.getName());
        SET_REFERENCE_Module.getImports().addAll(this.config.EPACKAGESSTACK);
        ModuleInternalsApplicator.createBasicRule(SET_REFERENCE_Module, this.eReference, this.contextEClassifier, this.target, null, null, OperationType.SET_REFERENCE);
        return SET_REFERENCE_Module;
    }
}

