/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;

public class SetAttributeGenerator {
    private EAttribute eAttribute;
    private EClassifier contextClassifier;
    private Configuration config = Configuration.getInstance();

    public SetAttributeGenerator(EClassifier contextClassifier, EAttribute eAttribute) {
        this.contextClassifier = contextClassifier;
        this.eAttribute = eAttribute;
    }

    public Module generate() {
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating SET_ATTRIBUTE: " + this.contextClassifier.getName() + " attribute " + this.eAttribute.getName()});
        Module SET_ATTRIBUTE_Module = HenshinFactory.eINSTANCE.createModule();
        SET_ATTRIBUTE_Module.getImports().addAll(this.config.EPACKAGESSTACK);
        Rule rule = HenshinFactory.eINSTANCE.createRule();
        rule.setActivated(true);
        rule.setName("set" + this.contextClassifier.getName() + ModuleInternalsApplicator.toCamelCase(this.eAttribute.getName()));
        rule.setDescription("Sets the EAttribute " + this.eAttribute.getName());
        SET_ATTRIBUTE_Module.getUnits().add((Object)rule);
        NodePair selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)this.contextClassifier));
        Node rhsNode = selectedNodePair.getRhsNode();
        HenshinRuleAnalysisUtilEx.createCreateAttribute((Node)rhsNode, (EAttribute)this.eAttribute, (String)ModuleInternalsApplicator.toCamelCase(this.eAttribute.getName()));
        String name = "SET_ATTRIBUTE_" + this.contextClassifier.getName() + "_" + ModuleInternalsApplicator.toCamelCase(this.eAttribute.getName());
        SET_ATTRIBUTE_Module.setName(name);
        SET_ATTRIBUTE_Module.setDescription("Sets " + this.contextClassifier.getName() + " " + ModuleInternalsApplicator.toCamelCase(this.eAttribute.getName()));
        return SET_ATTRIBUTE_Module;
    }
}

