/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;

public class RuleParameterGenerator {
    private Rule rule;

    public RuleParameterGenerator(Rule rule) {
        this.rule = rule;
    }

    public void generate() {
        for (Node lhsNode : this.rule.getLhs().getNodes()) {
            if (lhsNode.getName() != null && !lhsNode.getName().equals("")) {
                this.generateParameter(lhsNode.getName(), (EClassifier)lhsNode.getType());
            }
            for (Attribute attribute : lhsNode.getAttributes()) {
                this.generateParameter(attribute.getValue(), (EClassifier)attribute.getType().getEAttributeType());
            }
        }
        for (Node rhsNode : this.rule.getRhs().getNodes()) {
            if (rhsNode.getName() != null && !rhsNode.getName().equals("")) {
                this.generateParameter(rhsNode.getName(), (EClassifier)rhsNode.getType());
            }
            for (Attribute attribute : rhsNode.getAttributes()) {
                this.generateParameter(attribute.getValue(), (EClassifier)attribute.getType().getEAttributeType());
            }
        }
    }

    private void generateParameter(String name, EClassifier type) {
        if (this.rule.getParameter(name) != null && this.rule.getParameter(name).getType() == type) {
            return;
        }
        Parameter p = HenshinFactory.eINSTANCE.createParameter(name);
        p.setType(type);
        this.rule.getParameters().add((Object)p);
    }
}

