/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.ContainmentCycle;
import org.sidiff.common.emf.extensions.impl.ContainmentCyclePathStep;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class MoveUpGenerator {
    private EClassifier eClassifier;
    private ContainmentCycle cc;
    private static Configuration config = Configuration.getInstance();

    public MoveUpGenerator(EClassifier eClassifier, ContainmentCycle cc) {
        this.eClassifier = eClassifier;
        this.cc = cc;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        ContainmentCyclePathStep lastStep = this.cc.getBackwardPointingStep();
        EReference eRef = lastStep.getTargetingReference();
        EClassifier parent = (EClassifier)eRef.eContainer();
        String name = "MOVE_UP_" + this.eClassifier.getName() + "_FROM_" + parent.getName() + "_(" + eRef.getName() + ")" + "_TO_" + parent.getName() + "_(" + eRef.getName() + ")";
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating Move Up: " + name});
        Module MOVE_UP_Module = HenshinFactory.eINSTANCE.createModule();
        MOVE_UP_Module.setName(name);
        MOVE_UP_Module.setDescription("MOVE UPWARDs " + this.eClassifier.getName() + " from " + parent.getName() + "(Reference:" + eRef.getName() + ")" + " to " + parent.getName() + "(Reference:" + eRef.getName());
        MOVE_UP_Module.getImports().addAll(MoveUpGenerator.config.EPACKAGESSTACK);
        Rule r = ModuleInternalsApplicator.createBasicRule(MOVE_UP_Module, eRef, this.eClassifier, parent, eRef, parent, OperationType.MOVE_UP);
        NestedCondition nc = r.getLhs().createPAC("cyclePath");
        Graph graph = nc.getConclusion();
        Node oldSourceNodeInLHS = HenshinRuleAnalysisUtilEx.getNodeByName((Rule)r, (String)"OldSource", (boolean)true);
        Node oldSourceNodeInNCGraph = HenshinFactory.eINSTANCE.createNode();
        oldSourceNodeInNCGraph.setName("OldSource");
        oldSourceNodeInNCGraph.setType(oldSourceNodeInLHS.getType());
        graph.getNodes().add((Object)oldSourceNodeInNCGraph);
        Node newSourceNodeInLHS = HenshinRuleAnalysisUtilEx.getNodeByName((Rule)r, (String)"NewSource", (boolean)true);
        Node newSourceNodeInNCGraph = HenshinFactory.eINSTANCE.createNode();
        newSourceNodeInNCGraph.setName("NewSource");
        newSourceNodeInNCGraph.setType(newSourceNodeInLHS.getType());
        graph.getNodes().add((Object)newSourceNodeInNCGraph);
        Mapping mOldSrc = HenshinFactory.eINSTANCE.createMapping(oldSourceNodeInLHS, oldSourceNodeInNCGraph);
        Mapping mNewSrc = HenshinFactory.eINSTANCE.createMapping(newSourceNodeInLHS, newSourceNodeInNCGraph);
        nc.getMappings().add((Object)mNewSrc);
        nc.getMappings().add((Object)mOldSrc);
        Node nodeToConnectNewEdgeWith = newSourceNodeInNCGraph;
        int numberOfIntermediateSteps = this.cc.getNumberOfIntermediateSteps();
        if (numberOfIntermediateSteps == 0) {
            EReference backwardRef = this.cc.getBackwardPointingStep().getTargetingReference();
            Edge newEdge = HenshinFactory.eINSTANCE.createEdge(newSourceNodeInNCGraph, oldSourceNodeInNCGraph, backwardRef);
            graph.getEdges().add((Object)newEdge);
        } else {
            Node lastCreatedNode = null;
            for (ContainmentCyclePathStep step : this.cc.getIntermediateSteps()) {
                Edge newEdge;
                EClass eClass = (EClass)step.getTargetedEClassifier();
                EReference stepRef = step.getTargetingReference();
                if (!this.cc.isLastIntermediateStep(step).booleanValue()) {
                    Node newNode;
                    lastCreatedNode = newNode = HenshinFactory.eINSTANCE.createNode(graph, eClass, "");
                    newEdge = HenshinFactory.eINSTANCE.createEdge(nodeToConnectNewEdgeWith, newNode, stepRef);
                    graph.getEdges().add((Object)newEdge);
                    nodeToConnectNewEdgeWith = newNode;
                    continue;
                }
                if (lastCreatedNode != null) {
                    Edge newEdgeBackToOld = HenshinFactory.eINSTANCE.createEdge(lastCreatedNode, oldSourceNodeInNCGraph, stepRef);
                    graph.getEdges().add((Object)newEdgeBackToOld);
                    continue;
                }
                EReference backwardRef = stepRef;
                newEdge = HenshinFactory.eINSTANCE.createEdge(newSourceNodeInNCGraph, oldSourceNodeInNCGraph, backwardRef);
                graph.getEdges().add((Object)newEdge);
            }
        }
        return MOVE_UP_Module;
    }
}

