/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class MoveReferenceCombinationGenerator {
    private EClassifier eClassifier;
    private EReference oldEReference;
    private EReference newEReference;
    private EClassifier oldContext;
    private EClassifier newContext;
    private static Configuration config = Configuration.getInstance();

    public MoveReferenceCombinationGenerator(EClassifier eClassifier, EReference oldEReference, EClassifier oldContext, EClassifier newContext, EReference newEReference) {
        this.eClassifier = eClassifier;
        this.oldEReference = oldEReference;
        this.newEReference = newEReference;
        this.oldContext = oldContext;
        this.newContext = newContext;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "MOVE_REF_COMBI_" + this.eClassifier.getName() + "_FROM_" + this.oldContext.getName() + "_(" + this.oldEReference.getName() + ")" + "_TO_" + this.newContext.getName() + "_(" + this.newEReference.getName() + ")";
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating Move Reference Combination : " + name});
        Module MOVE_Module = HenshinFactory.eINSTANCE.createModule();
        MOVE_Module.setName(name);
        MOVE_Module.setDescription("MOVEs " + this.eClassifier.getName() + " from " + this.oldContext.getName() + "(Reference:" + this.oldEReference.getName() + ")" + " to " + this.newContext.getName() + "(Reference:" + this.newEReference.getName());
        MOVE_Module.getImports().addAll(MoveReferenceCombinationGenerator.config.EPACKAGESSTACK);
        ModuleInternalsApplicator.createBasicRule(MOVE_Module, this.oldEReference, this.eClassifier, this.oldContext, this.newEReference, this.newContext, OperationType.MOVE_REFERENCE_COMBINATION);
        return MOVE_Module;
    }
}

