/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.Mask;
import org.sidiff.common.henshin.HenshinModuleAnalysis;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class MoveMaskedElementGenerator {
    private EReference oldEReference;
    private EReference newEReference;
    private EClassifier oldContext;
    private EClassifier newContext;
    private Mask mask;
    private static Configuration config = Configuration.getInstance();
    private OperationType opType;

    public MoveMaskedElementGenerator(Mask mask, EReference oldEReference, EClassifier oldContext, EClassifier newContext, EReference newEReference, OperationType opType) {
        this.mask = mask;
        this.oldEReference = oldEReference;
        this.newEReference = newEReference;
        this.oldContext = oldContext;
        this.newContext = newContext;
        this.opType = opType;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "MOVE_" + this.mask.getName() + "_FROM_" + this.oldContext.getName() + "_(" + this.oldEReference.getName() + ")" + "_TO_" + this.newContext.getName() + "_(" + this.newEReference.getName() + ")";
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating Move Masked ELement : " + name});
        Module MOVE_Module = HenshinFactory.eINSTANCE.createModule();
        MOVE_Module.setName(name);
        MOVE_Module.setDescription("Moves " + this.mask.getName() + " from " + this.oldContext.getName() + "(Reference:" + this.oldEReference.getName() + ") to " + this.newContext.getName() + "(Reference:" + this.newEReference.getName() + ")");
        MOVE_Module.getImports().addAll(MoveMaskedElementGenerator.config.EPACKAGESSTACK);
        ModuleInternalsApplicator.createBasicRule(MOVE_Module, this.oldEReference, this.mask.getOriginalEClassifier(), this.oldContext, this.newEReference, this.newContext, this.opType);
        Rule rule = (Rule)HenshinModuleAnalysis.getAllRules((Module)MOVE_Module).get(0);
        NodePair np = HenshinRuleAnalysisUtilEx.getNodePair((Rule)rule, (EClass)((EClass)this.mask.getOriginalEClassifier()), (String)"Selected");
        HenshinRuleAnalysisUtilEx.createPreservedAttribute((NodePair)np, (EAttribute)this.mask.getEAttributeContainingFakeType(), (String)("\"" + this.mask.getTypeExtension().getName() + "\""), (Boolean)false);
        return MOVE_Module;
    }
}

