/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class MoveGenerator {
    private EClassifier eClassifier;
    private EReference eReference;
    private EClassifier oldContext;
    private EClassifier newContext;
    private static Configuration config = Configuration.getInstance();

    public MoveGenerator(EClassifier eClassifier, EReference eReference, EClassifier oldContext, EClassifier newContext) {
        this.eClassifier = eClassifier;
        this.eReference = eReference;
        this.oldContext = oldContext;
        this.newContext = newContext;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "MOVE_" + this.eClassifier.getName() + "_FROM_" + this.oldContext.getName() + "_(" + this.eReference.getName() + ")" + "_TO_" + this.newContext.getName() + "_(" + this.eReference.getName() + ")";
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating Move : " + name});
        Module MOVE_Module = HenshinFactory.eINSTANCE.createModule();
        MOVE_Module.setName(name);
        MOVE_Module.setDescription("MOVEs " + this.eClassifier.getName() + " from " + this.oldContext.getName() + "(Reference:" + this.eReference.getName() + ")" + " to " + this.newContext.getName() + "(Reference:" + this.eReference.getName());
        MOVE_Module.getImports().addAll(MoveGenerator.config.EPACKAGESSTACK);
        ModuleInternalsApplicator.createBasicRule(MOVE_Module, this.eReference, this.eClassifier, this.oldContext, this.eReference, this.newContext, OperationType.MOVE);
        return MOVE_Module;
    }
}

