/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.EMFUtil;
import org.sidiff.common.emf.exceptions.EPackageNotFoundException;
import org.sidiff.common.henshin.HenshinModuleAnalysis;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.ParameterInfo;
import org.sidiff.editrule.generator.serge.configuration.Configuration;

public class MainUnitGenerator {
    private Module module;
    private PriorityUnit prioUnit;

    public MainUnitGenerator(Module module) {
        this.module = module;
    }

    public void generate() {
        this.prioUnit = HenshinFactory.eINSTANCE.createPriorityUnit();
        this.prioUnit.setActivated(true);
        this.prioUnit.setName("mainUnit");
        EList rulesUnderModule = HenshinModuleAnalysis.getAllRules((Module)this.module);
        assert (rulesUnderModule.size() == 1);
        Rule rule = (Rule)rulesUnderModule.get(0);
        this.generateUnitParameters(rule);
        this.prioUnit.getSubUnits().add((Object)rule);
        this.module.getUnits().add((Object)this.prioUnit);
        this.organizeImports(this.module);
    }

    private void generateUnitParameters(Rule rule) {
        for (Node lhsNode : rule.getLhs().getNodes()) {
            Parameter objectInParam = null;
            objectInParam = rule.getParameter(lhsNode.getName());
            if (objectInParam != null) {
                this.generateUnitParameter(objectInParam, ParameterInfo.ParameterDirection.IN);
            }
            for (Attribute attribute : lhsNode.getAttributes()) {
                Parameter valueInParam = null;
                valueInParam = rule.getParameter(attribute.getValue());
                if (valueInParam == null) continue;
                this.generateUnitParameter(valueInParam, ParameterInfo.ParameterDirection.IN);
            }
        }
        for (Node rhsNode : rule.getRhs().getNodes()) {
            if (HenshinRuleAnalysisUtilEx.isCreationNode((Node)rhsNode)) {
                Parameter objectOutParam = null;
                objectOutParam = rule.getParameter(rhsNode.getName());
                if (objectOutParam != null) {
                    this.generateUnitParameter(objectOutParam, ParameterInfo.ParameterDirection.OUT);
                }
            }
            for (Attribute attribute : rhsNode.getAttributes()) {
                Parameter valueInParam = null;
                valueInParam = rule.getParameter(attribute.getValue());
                if (valueInParam == null) continue;
                this.generateUnitParameter(valueInParam, ParameterInfo.ParameterDirection.IN);
            }
        }
    }

    private void generateUnitParameter(Parameter ruleParameter, ParameterInfo.ParameterDirection direction) {
        Parameter unitParameter = HenshinFactory.eINSTANCE.createParameter(ruleParameter.getName());
        if (unitParameter.getName().equals("Selected")) {
            unitParameter.setName("selectedEObject");
        }
        unitParameter.setType(ruleParameter.getType());
        ParameterMapping pm = HenshinFactory.eINSTANCE.createParameterMapping();
        if (direction.equals((Object)ParameterInfo.ParameterDirection.IN)) {
            pm.setSource(unitParameter);
            pm.setTarget(ruleParameter);
        } else {
            pm.setSource(ruleParameter);
            pm.setTarget(unitParameter);
        }
        this.prioUnit.getParameters().add((Object)unitParameter);
        this.prioUnit.getParameterMappings().add((Object)pm);
    }

    private void organizeImports(Module module) {
        ArrayList<EPackage> actuallyUsedEPackages = new ArrayList<EPackage>();
        for (Rule rule : HenshinModuleAnalysis.getAllRules((Module)module)) {
            ArrayList allNodesInRule = new ArrayList();
            allNodesInRule.addAll(rule.getRhs().getNodes());
            allNodesInRule.addAll(rule.getLhs().getNodes());
            for (Node node : allNodesInRule) {
                EPackage usedEPackage = node.getType().getEPackage();
                if (actuallyUsedEPackages.contains(usedEPackage)) continue;
                actuallyUsedEPackages.add(usedEPackage);
            }
        }
        EPackage mainMetaModel = (EPackage)Configuration.getInstance().EPACKAGESSTACK.firstElement();
        ArrayList subsOfMain = new ArrayList();
        try {
            subsOfMain.addAll(EMFUtil.getAllSubEPackages((EPackage)mainMetaModel));
        }
        catch (EPackageNotFoundException e) {
            e.printStackTrace();
        }
        Iterator itImports = module.getImports().iterator();
        while (itImports.hasNext()) {
            EPackage currentEPackage = (EPackage)itImports.next();
            if (mainMetaModel.equals(currentEPackage)) continue;
            boolean actuallyUsed = actuallyUsedEPackages.contains(currentEPackage);
            if (!subsOfMain.contains(currentEPackage) && actuallyUsed) continue;
            itImports.remove();
        }
    }
}

