/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinModuleAnalysis;
import org.sidiff.common.henshin.HenshinModuleUtil;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.types.OperationType;

public class InverseGenerator {
    private Module inputModule;
    private OperationType opType;

    public InverseGenerator(Module inputModule, OperationType inputOperationType) {
        this.inputModule = inputModule;
        this.opType = inputOperationType;
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "";
        String description = "";
        Module inverse = null;
        Rule firstRule = null;
        switch (this.opType) {
            case CREATE: {
                name = this.inputModule.getName().replaceFirst("CREATE_", "DELETE_");
                description = this.inputModule.getDescription().replaceFirst("Creates", "Deletes");
                inverse = HenshinModuleUtil.createInverse((String)name, (String)description, (Module)this.inputModule);
                firstRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)inverse).get(0);
                firstRule.setName(firstRule.getName().replaceFirst("create", "delete"));
                firstRule.setDescription(firstRule.getDescription().replaceFirst("create", "delete"));
                break;
            }
            case ADD: {
                name = this.inputModule.getName().replaceFirst("ADD_", "REMOVE_");
                description = this.inputModule.getDescription().replaceFirst("Adds to", "Removes");
                inverse = HenshinModuleUtil.createInverse((String)name, (String)description, (Module)this.inputModule);
                firstRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)inverse).get(0);
                firstRule.setName(firstRule.getName().replaceFirst("addTo", "removeFrom"));
                firstRule.setDescription(firstRule.getDescription().replaceFirst("Adds to", "Removes from"));
                HenshinRuleAnalysisUtilEx.getNodeByName((Rule)firstRule, (String)"NewTarget", (boolean)true).setName("OldTarget");
                HenshinRuleAnalysisUtilEx.getNodeByName((Rule)firstRule, (String)"NewTarget", (boolean)false).setName("OldTarget");
                break;
            }
            case SET_ATTRIBUTE: {
                name = this.inputModule.getName().replaceFirst("SET_ATTRIBUTE_", "UNSET_ATTRIBUTE_");
                description = this.inputModule.getDescription().replaceFirst("Sets (an attribute)", "Unsets (an attribute)");
                inverse = HenshinModuleUtil.createInverse((String)name, (String)description, (Module)this.inputModule);
                firstRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)inverse).get(0);
                firstRule.setName(firstRule.getName().replaceFirst("setAttribute", "unsetAtttribute"));
                firstRule.setDescription(firstRule.getDescription().replaceFirst("Set (an attribute)", "Unset (an attribute)"));
                break;
            }
            case SET_REFERENCE: {
                name = this.inputModule.getName().replaceFirst("SET_REFERENCE_", "UNSET_REFERENCE_");
                description = this.inputModule.getDescription().replaceFirst("Sets (a reference)", "Unsets (a reference)");
                inverse = HenshinModuleUtil.createInverse((String)name, (String)description, (Module)this.inputModule);
                firstRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)inverse).get(0);
                firstRule.setName(firstRule.getName().replaceFirst("setReference", "unsetReference"));
                firstRule.setDescription(firstRule.getDescription().replaceFirst("Set (a reference)", "Unset (a reference)"));
                break;
            }
            default: {
                throw new OperationTypeNotImplementedException(this.opType);
            }
        }
        this.replaceNewsWithToBeDeleted(inverse);
        return inverse;
    }

    private void replaceNewsWithToBeDeleted(Module module) {
        for (Rule r : HenshinModuleAnalysis.getAllRules((Module)module)) {
            for (Node n : r.getLhs().getNodes()) {
                String nN = n.getName();
                if (nN == null || !nN.equals("New")) continue;
                n.setName("ToBeDeleted");
            }
            for (Node n : r.getRhs().getNodes()) {
                if (!n.getName().equals("New")) continue;
                n.setName("ToBeDeleted");
            }
            for (Parameter p : r.getParameters()) {
                String pN = p.getName();
                if (pN == null || !pN.equals("New")) continue;
                p.setName("ToBeDeleted");
            }
        }
    }
}

