/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;

public class CreateGenerator {
    private EReference containmentReference;
    private EClassifier contextClassifier;
    private EClassifier child;
    private EClassifierInfo childInfo;
    private Configuration config = Configuration.getInstance();

    public CreateGenerator(EReference containmentReference, EClassifier contextClassifier, EClassifierInfo childInfo) {
        this.containmentReference = containmentReference;
        this.contextClassifier = contextClassifier;
        this.childInfo = childInfo;
        this.child = childInfo.getTheEClassifier();
    }

    public Module generate() throws OperationTypeNotImplementedException {
        Module module = null;
        Rule rule = null;
        Node newNode = null;
        if (this.contextClassifier != null) {
            module = HenshinFactory.eINSTANCE.createModule();
            String name = "CREATE_" + this.child.getName() + "_IN_" + this.contextClassifier.getName() + "_(" + this.containmentReference.getName() + ")";
            LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating " + name});
            module.setDescription("Creates one " + this.child.getName() + " in " + this.contextClassifier.getName());
            module.setName(name);
            module.getImports().addAll(this.config.EPACKAGESSTACK);
            rule = ModuleInternalsApplicator.createBasicRule(module, this.containmentReference, this.child, this.contextClassifier, null, null, OperationType.CREATE);
            newNode = (Node)HenshinRuleAnalysisUtilEx.getRHSMinusLHSNodes((Rule)rule).get(0);
        } else {
            module = HenshinFactory.eINSTANCE.createModule();
            String name = "CREATE_" + this.child.getName();
            LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating " + name});
            module.setDescription("Creates one " + this.child.getName());
            module.setName(name);
            module.getImports().addAll(this.config.EPACKAGESSTACK);
            rule = ModuleInternalsApplicator.createBasicRule(module, null, this.child, null, null, null, OperationType.CREATE);
            newNode = (Node)HenshinRuleAnalysisUtilEx.getRHSMinusLHSNodes((Rule)rule).get(0);
        }
        if (this.childInfo.hasMandatories()) {
            ModuleInternalsApplicator.createMandatoryChildren(rule, this.childInfo, newNode, OperationType.CREATE, this.config.REDUCETOSUPERTYPE_CREATEDELETE);
            ModuleInternalsApplicator.createMandatoryNeighbours(rule, this.childInfo, newNode, OperationType.CREATE, this.config.REDUCETOSUPERTYPE_CREATEDELETE);
        }
        return module;
    }
}

