/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.types.OperationType;
import org.silift.common.util.access.EMFMetaAccessEx;

public class ChangeReferenceGenerator {
    private EClassifier contextClass;
    private EReference reference;
    private EClassifier target;
    private Configuration config = Configuration.getInstance();

    public ChangeReferenceGenerator(EReference reference, EClass contextClass) {
        assert (reference.getLowerBound() >= 1 && reference.getLowerBound() == reference.getUpperBound());
        assert (EMFMetaAccessEx.isAssignableTo((EClass)contextClass, (EClass)((EClass)reference.eContainer())));
        this.reference = reference;
        this.contextClass = contextClass;
        this.target = reference.getEReferenceType();
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "CHANGE_REFERENCE_" + this.contextClass.getName() + "_(" + this.reference.getName() + ")" + "_TGT_" + this.target.getName();
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating CHANGE_REFERENCE : " + name});
        Module CHANGE_REFERENCE_Module = HenshinFactory.eINSTANCE.createModule();
        CHANGE_REFERENCE_Module.setName(name);
        CHANGE_REFERENCE_Module.setDescription("CHANGEs " + this.contextClass.getName() + "'s reference " + this.reference.getName() + " the target " + this.target.getName());
        CHANGE_REFERENCE_Module.getImports().addAll(this.config.EPACKAGESSTACK);
        ModuleInternalsApplicator.createBasicRule(CHANGE_REFERENCE_Module, this.reference, this.contextClass, this.target, null, null, OperationType.CHANGE_REFERENCE);
        return CHANGE_REFERENCE_Module;
    }
}

