/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.generators.actions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;

public class AddGenerator {
    private EReference outReference;
    private EClass contextClass;
    private EClass targetClass;
    private static Configuration config = Configuration.getInstance();

    public AddGenerator(EReference outReference, EClass contextClassifier) {
        this.outReference = outReference;
        this.contextClass = contextClassifier;
        this.targetClass = outReference.getEReferenceType();
    }

    public Module generate() throws OperationTypeNotImplementedException {
        String name = "ADD_" + this.contextClass.getName() + "_(" + this.outReference.getName() + ")" + "_TGT_" + this.targetClass.getName();
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Generating ADD : " + name});
        Module module = HenshinFactory.eINSTANCE.createModule();
        module.setName(name);
        module.setDescription("Adds to " + this.contextClass.getName() + "'s reference " + this.outReference.getName() + " the target " + this.targetClass.getName());
        module.getImports().addAll(AddGenerator.config.EPACKAGESSTACK);
        Rule rule = this.createRule();
        module.getUnits().add((Object)rule);
        boolean isOWL = this.contextClass.getEPackage().getName().equals("owl");
        if (isOWL && module.getName().trim().equals("ADD_ObjectUnionOf_(classExpressions)_TGT_ClassExpression")) {
            rule.setInjectiveMatching(false);
        }
        return module;
    }

    private Rule createRule() {
        Rule rule = HenshinFactory.eINSTANCE.createRule();
        rule.setActivated(true);
        rule.setName("addTo" + this.contextClass.getName() + "_" + this.outReference.getName() + "_" + this.targetClass.getName());
        rule.setDescription("Adds to " + this.contextClass.getName() + "'s reference " + this.outReference.getName() + " the target " + this.targetClass.getName());
        NodePair selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)this.contextClass);
        NodePair newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewTarget", (EClass)this.targetClass);
        HenshinRuleAnalysisUtilEx.createCreateEdge((Node)selectedNodePair.getRhsNode(), (Node)newNodePair.getRhsNode(), (EReference)this.outReference);
        return rule;
    }
}

