/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.filter;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinModuleAnalysis;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.serge.util.ModuleConsistencyChecker;
import org.sidiff.editrule.generator.serge.util.RuleExecutionChecker;
import org.sidiff.editrule.generator.types.OperationType;

public class ExecutableFilter {
    public void applyOn(Map<OperationType, Set<Module>> allModules) {
        for (OperationType opType : allModules.keySet()) {
            Set<Module> moduleSet = allModules.get(opType);
            Iterator<Module> moduleIterator = moduleSet.iterator();
            while (moduleIterator.hasNext()) {
                ModuleConsistencyChecker consistencyChecker;
                Module module = moduleIterator.next();
                Rule rule = (Rule)HenshinModuleAnalysis.getAllRules((Module)module).get(0);
                RuleExecutionChecker executionChecker = new RuleExecutionChecker(rule);
                if (!executionChecker.isExecutable()) {
                    LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Not executable operation: " + module.getName()});
                    moduleIterator.remove();
                }
                if (!(consistencyChecker = new ModuleConsistencyChecker(module)).isViolating()) continue;
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Consistency violationg operation: " + module.getName()});
                moduleIterator.remove();
            }
        }
    }
}

