/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.sidiff.common.emf.EMFUtil;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.types.OperationType;

public class ElementFilter {
    private static ArrayList<EClassifier> blackList;
    private static ArrayList<EClassifier> whiteList;
    private static Configuration c;
    private static EClassifierInfoManagement ECM;
    private static ElementFilter instance;

    static {
        instance = null;
    }

    public static ElementFilter getInstance() {
        if (instance == null) {
            instance = new ElementFilter();
        }
        return instance;
    }

    private ElementFilter() {
        c = Configuration.getInstance();
        ECM = EClassifierInfoManagement.getInstance();
    }

    public void setBlackList(ArrayList<EClassifier> bList) {
        blackList = bList;
    }

    public void setWhiteList(ArrayList<EClassifier> wList) {
        whiteList = wList;
    }

    public ArrayList<EClassifier> getBlackList() {
        return blackList;
    }

    public ArrayList<EClassifier> getWhiteList() {
        return whiteList;
    }

    public Boolean isAllowedAsModuleBasis(EClassifier eClassifier, OperationType opType) throws OperationTypeNotImplementedException {
        EClassifierInfo eInf = ECM.getEClassifierInfo(eClassifier);
        boolean blackListed = blackList.contains(eClassifier);
        boolean whiteListed = whiteList.contains(eClassifier);
        boolean assumeAllOnWhitelist = whiteList.isEmpty();
        boolean requiredBySubtypes = ElementFilter.isRequiredByWhitelistedSubtypes(eClassifier);
        boolean requiredByStereotypes = ElementFilter.isRequiredByWhitelistedStereotype(eClassifier);
        boolean isNotCrossReferencedOrNotContainedInMainMetaModel = !this.crossReferencedOrContainedInMainMetaModel(eClassifier);
        switch (opType) {
            case CREATE: {
                if (!(!(eClassifier instanceof EClass) || eClassifier instanceof EClass && ((EClass)eClassifier).isAbstract() || !eInf.selfMayHaveTransformations() || c.isAnUnnestableRoot(eClassifier) != false || requiredByStereotypes && !c.isRoot(eClassifier) || !whiteListed && !assumeAllOnWhitelist || blackListed && !requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case ADD: {
                if (!(!whiteListed && !assumeAllOnWhitelist && !requiredBySubtypes && !requiredByStereotypes && !c.isRoot(eClassifier) || blackListed && !requiredBySubtypes && !requiredByStereotypes && !c.isRoot(eClassifier)) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case CHANGE_REFERENCE: {
                if (!(!whiteListed && !assumeAllOnWhitelist && !requiredBySubtypes && !requiredByStereotypes || blackListed && !requiredBySubtypes && !requiredByStereotypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case CHANGE_LITERAL: {
                if (!(!whiteListed && !assumeAllOnWhitelist && !requiredBySubtypes && !requiredByStereotypes || blackListed && !requiredBySubtypes && !requiredByStereotypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE: {
                if (!(!(eClassifier instanceof EClass) || eClassifier instanceof EClass && ((EClass)eClassifier).isAbstract() || !eInf.selfMayHaveTransformations() || c.isAnUnnestableRoot(eClassifier) != false || requiredByStereotypes && !c.isRoot(eClassifier) || !whiteListed && !assumeAllOnWhitelist || blackListed && !requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_REFERENCE_COMBINATION: {
                if (!(!(eClassifier instanceof EClass) || eClassifier instanceof EClass && ((EClass)eClassifier).isAbstract() || !eInf.selfMayHaveTransformations() || c.isAnUnnestableRoot(eClassifier) != false || requiredByStereotypes && !c.isRoot(eClassifier) || !whiteListed && !assumeAllOnWhitelist || blackListed && !requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_UP: {
                if (!(!(eClassifier instanceof EClass) || eClassifier instanceof EClass && ((EClass)eClassifier).isAbstract() || !eInf.selfMayHaveTransformations() || c.isAnUnnestableRoot(eClassifier) != false || requiredByStereotypes && !c.isRoot(eClassifier) || !whiteListed && !assumeAllOnWhitelist || blackListed && !requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_DOWN: {
                if (!(!(eClassifier instanceof EClass) || eClassifier instanceof EClass && ((EClass)eClassifier).isAbstract() || !eInf.selfMayHaveTransformations() || c.isAnUnnestableRoot(eClassifier) != false || requiredByStereotypes && !c.isRoot(eClassifier) || !whiteListed && !assumeAllOnWhitelist || blackListed && !requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case SET_ATTRIBUTE: {
                if (!(!whiteListed && !assumeAllOnWhitelist && !requiredByStereotypes || blackListed && !requiredBySubtypes && !requiredByStereotypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case SET_REFERENCE: {
                if (!(!whiteListed && !assumeAllOnWhitelist && !requiredByStereotypes || blackListed && !requiredBySubtypes && !requiredByStereotypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case UNSET_ATTRIBUTE: {
                return true;
            }
            case UNSET_REFERENCE: {
                return true;
            }
            case DELETE: {
                return true;
            }
            case REMOVE: {
                return true;
            }
            default: {
                throw new OperationTypeNotImplementedException(opType);
            }
        }
        return true;
    }

    public Boolean isAllowedAsDangling(EClassifier eClassifier, OperationType opType, Boolean preferSupertypes) throws OperationTypeNotImplementedException {
        boolean blackListed = blackList.contains(eClassifier);
        boolean whiteListed = whiteList.contains(eClassifier);
        boolean assumeAllOnWhitelist = whiteList.isEmpty();
        boolean requiredBySubtypes = ElementFilter.isRequiredByWhitelistedSubtypes(eClassifier);
        boolean requiredByChildren = this.isRequiredByWhitelistedChildren(eClassifier);
        boolean isNotCrossReferencedOrNotContainedInMainMetaModel = !this.crossReferencedOrContainedInMainMetaModel(eClassifier);
        boolean hardCutOff = blackListed && !ElementFilter.c.PREVENT_INCONSISTENCY_THROUGHSKIPPING || blackList.isEmpty() && !assumeAllOnWhitelist && !ElementFilter.c.PREVENT_INCONSISTENCY_THROUGHSKIPPING;
        switch (opType) {
            case CREATE: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren || requiredBySubtypes) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case ADD: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_REFERENCE_COMBINATION: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_UP: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case MOVE_DOWN: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case CHANGE_REFERENCE: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case SET_ATTRIBUTE: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case SET_REFERENCE: {
                if (!hardCutOff && (hardCutOff || whiteListed || assumeAllOnWhitelist || requiredByChildren) && !isNotCrossReferencedOrNotContainedInMainMetaModel) break;
                return false;
            }
            case UNSET_ATTRIBUTE: {
                return true;
            }
            case UNSET_REFERENCE: {
                return true;
            }
            case DELETE: {
                return true;
            }
            case REMOVE: {
                return true;
            }
            default: {
                throw new OperationTypeNotImplementedException(opType);
            }
        }
        return true;
    }

    private Boolean isRequiredByWhitelistedChildren(EClassifier eClassifier) {
        boolean requiredByChildren = false;
        block0: for (EClassifier whiteListedEClass : whiteList) {
            for (Map.Entry entry : ECM.getAllParentContexts(whiteListedEClass, Boolean.valueOf(false)).entrySet()) {
                List parentContexts;
                boolean notFixedAndRequired;
                EReference eRefChildToParent = ((EReference)entry.getKey()).getEOpposite();
                if (eRefChildToParent == null) continue;
                int lb = eRefChildToParent.getLowerBound();
                int ub = eRefChildToParent.getUpperBound();
                boolean bl = notFixedAndRequired = ub - lb > 0 && lb > 0;
                if (!notFixedAndRequired || !(parentContexts = (List)entry.getValue()).contains(eClassifier)) continue;
                requiredByChildren = true;
                continue block0;
            }
        }
        return requiredByChildren;
    }

    private static Boolean isRequiredByWhitelistedSubtypes(EClassifier eClassifier) {
        boolean isRequired = false;
        EClassifierInfo eInfo = ECM.getEClassifierInfo(eClassifier);
        Set subTypes = ECM.getAllSubTypes(eInfo);
        for (EClassifierInfo subTypeInfo : subTypes) {
            EClassifier subtype = subTypeInfo.getTheEClassifier();
            if (!whiteList.contains(subtype)) continue;
            isRequired = true;
            break;
        }
        return isRequired;
    }

    private static Boolean isRequiredByWhitelistedStereotype(EClassifier eClassifier) {
        if (ElementFilter.c.PROFILE_APPLICATION_IN_USE.booleanValue()) {
            Set stereotypes = ECM.getAllStereotypes(eClassifier);
            for (EClassifier stereotype : stereotypes) {
                if (!whiteList.contains(stereotype)) continue;
                return true;
            }
        }
        return false;
    }

    protected static List<String> extractAllEClassifierNames(ArrayList<EClassifier> eClassifierList) {
        ArrayList<String> list = new ArrayList<String>();
        for (EClassifier ec : eClassifierList) {
            list.add(ec.getName());
        }
        return list;
    }

    public HashMap<EReference, List<EClass>> getAllAllowedParentContexts(EClassifier childEClassifier, Boolean reduceToSupertype, OperationType operationType) throws OperationTypeNotImplementedException {
        HashMap<EReference, List<EClass>> allAllowedParents = new HashMap<EReference, List<EClass>>();
        ArrayList eClassifierMasks = new ArrayList();
        eClassifierMasks.addAll(ECM.getEClassifierInfo(childEClassifier).getMasks());
        HashMap allParents = ECM.getAllParentContexts(childEClassifier, reduceToSupertype);
        for (EReference eRef : allParents.keySet()) {
            assert (eRef.isContainment()) : "eRef is no containment but should be";
            if (eRef.getLowerBound() == eRef.getUpperBound() || eRef.isDerived() || !eRef.isChangeable() || eRef.isUnsettable() || eRef.isTransient()) continue;
            EClass parent = (EClass)eRef.eContainer();
            if (this.isAllowedAsDangling((EClassifier)parent, operationType, reduceToSupertype).booleanValue()) {
                if (allAllowedParents.get(eRef) == null) {
                    ArrayList<EClass> newParentList = new ArrayList<EClass>();
                    newParentList.add(parent);
                    allAllowedParents.put(eRef, newParentList);
                } else {
                    allAllowedParents.get(eRef).add(parent);
                }
            }
            ArrayList<EReference> allReferences = new ArrayList<EReference>();
            allReferences.addAll(allAllowedParents.keySet());
        }
        return allAllowedParents;
    }

    private boolean crossReferencedOrContainedInMainMetaModel(EClassifier eClassifier) {
        Configuration config = Configuration.getInstance();
        boolean crossReferencedOrContainedInMainMetaModel = false;
        EList resourceContents = eClassifier.eResource().getContents();
        EPackage rootEPackage = (EPackage)resourceContents.get(0);
        String eClassifiersRootPackageNsURI = rootEPackage.getNsURI();
        Stack<EPackage> ePackageStack = Configuration.getInstance().EPACKAGESSTACK;
        for (EPackage ePackage : ePackageStack) {
            if (ePackage.getNsURI().equals(config.METAMODEL.getNsURI()) && eClassifiersRootPackageNsURI.equals(config.METAMODEL.getNsURI())) {
                crossReferencedOrContainedInMainMetaModel = true;
                break;
            }
            if (ePackage.getNsURI().equals(config.METAMODEL.getNsURI()) || eClassifiersRootPackageNsURI.equals(config.METAMODEL.getNsURI())) continue;
            HashMap relevantParents = EClassifierInfoManagement.getInstance().getAllOptionalParentContext(eClassifier, Boolean.valueOf(true));
            for (Map.Entry eRefEntry : relevantParents.entrySet()) {
                EClassifier container = (EClassifier)((EReference)eRefEntry.getKey()).eContainer();
                List eosInMM = EMFUtil.createListFromEAllContents((EObject)Configuration.getInstance().METAMODEL);
                if (!eosInMM.contains(container)) continue;
                crossReferencedOrContainedInMainMetaModel = true;
            }
        }
        return crossReferencedOrContainedInMainMetaModel;
    }
}

