/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.henshin.HenshinModuleAnalysis;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.serge.util.RuleSemanticsChecker;
import org.sidiff.editrule.generator.types.OperationType;

public class DuplicateFilter {
    public void filterIdenticalByName(Map<OperationType, Set<Module>> allModules) {
        HashSet<String> moduleNames = new HashSet<String>();
        for (OperationType opType : allModules.keySet()) {
            Set<Module> moduleSet = allModules.get(opType);
            Iterator<Module> moduleIterator = moduleSet.iterator();
            while (moduleIterator.hasNext()) {
                Module module = moduleIterator.next();
                if (moduleNames.contains(module.getName())) {
                    LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Filter identical operation: " + module.getName()});
                    moduleIterator.remove();
                    continue;
                }
                moduleNames.add(module.getName());
            }
        }
    }

    public void filterAddSet(Set<Module> addModules, Set<Module> setReferenceModules) {
        block0: for (Module setModule : setReferenceModules) {
            Iterator<Module> addModulesIterator = addModules.iterator();
            while (addModulesIterator.hasNext()) {
                Rule setRule;
                Module addModule = addModulesIterator.next();
                Rule addRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)addModule).get(0);
                RuleSemanticsChecker checker = new RuleSemanticsChecker(addRule, setRule = (Rule)HenshinModuleAnalysis.getAllRules((Module)setModule).get(0));
                if (!checker.isEqual()) continue;
                LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Filter duplicate (ADD/SET_REFERENCE): " + addModule.getName()});
                addModulesIterator.remove();
                continue block0;
            }
        }
    }

    public void filterRemoveUnset(Set<Module> removeModules, Set<Module> unsetReferenceModules) {
    }
}

