/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.core.ModuleInternalsApplicator;
import org.sidiff.editrule.generator.serge.core.ReplacementTable;
import org.sidiff.editrule.generator.serge.core.ReplacementTableRow;
import org.sidiff.editrule.generator.types.OperationType;

public class TypeReplacer {
    private Module originalModule;
    private OperationType opType;
    private Boolean reduceToSuperType;
    private EClassifierInfoManagement ECM = EClassifierInfoManagement.getInstance();

    public TypeReplacer(Module originalModule, OperationType opType, boolean reduceToSuperType) throws OperationTypeNotImplementedException {
        this.originalModule = originalModule;
        this.opType = opType;
        this.reduceToSuperType = reduceToSuperType;
        this.ECM = EClassifierInfoManagement.getInstance();
    }

    public Set<Module> replace() throws OperationTypeNotImplementedException {
        HashSet<Module> modules = new HashSet<Module>();
        ReplacementTable rT = new ReplacementTable(this.originalModule);
        if (rT.hasReplacements()) {
            rT.printTable();
            for (ReplacementTableRow row : rT.getRows()) {
                Module copy = (Module)EcoreUtil.copy((EObject)this.originalModule);
                for (EClassifier replacement : row) {
                    Node originalNode = rT.getHeader().get(row.getIndexOf(replacement));
                    Rule rule = (Rule)copy.getUnits().get(0);
                    Node nodeInCopy = HenshinRuleAnalysisUtilEx.getNodeByName((Rule)rule, (String)originalNode.getName(), (boolean)false);
                    nodeInCopy.setType((EClass)replacement);
                    EClassifierInfo replacementInfo = this.ECM.getEClassifierInfo(replacement);
                    ModuleInternalsApplicator.createMandatoryChildren(rule, replacementInfo, nodeInCopy, this.opType, this.reduceToSuperType);
                    ModuleInternalsApplicator.createMandatoryNeighbours(rule, replacementInfo, nodeInCopy, this.opType, this.reduceToSuperType);
                    long id = System.nanoTime();
                    if (copy.getName().matches(".*(_Variant\\d*\\w*)$")) {
                        copy.setDescription(copy.getDescription().replaceAll("(Variant\\d*)$", "Variant" + String.valueOf(id)));
                        copy.setName(copy.getName().replaceAll("(Variant\\d*)$", "Variant" + String.valueOf(id)));
                    } else {
                        copy.setDescription(String.valueOf(copy.getDescription()) + " Variant" + id);
                        copy.setName(String.valueOf(copy.getName()) + "_Variant" + id);
                    }
                    List nodesAfterMandatoryAdditons = HenshinRuleAnalysisUtilEx.getChildNodesWithinAContainmentRelation((Module)copy, (HenshinRuleAnalysisUtilEx.NodeKindSelection)HenshinRuleAnalysisUtilEx.NodeKindSelection.CREATE, (Boolean)false);
                    for (Node node : nodesAfterMandatoryAdditons) {
                        boolean hasReplacables;
                        boolean isNewNode = HenshinRuleAnalysisUtilEx.getNodeByName((Rule)((Rule)this.originalModule.getUnits().get(0)), (String)node.getName(), (boolean)false) == null;
                        boolean bl = hasReplacables = !this.ECM.getAllSubTypes((EClassifier)node.getType()).isEmpty();
                        if (!isNewNode || !hasReplacables) continue;
                        TypeReplacer newTypeReplacer = new TypeReplacer(copy, this.opType, this.reduceToSuperType);
                        modules.addAll(newTypeReplacer.replace());
                    }
                    modules.add(copy);
                }
            }
        }
        return modules;
    }
}

