/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.editrule.generator.serge.core.ReplacementTableHeader;
import org.sidiff.editrule.generator.serge.core.ReplacementTableRow;

public class ReplacementTable {
    private ReplacementTableHeader tableHeader;
    private Set<ReplacementTableRow> tableRows;
    private EClassifierInfoManagement ECM;

    public ReplacementTable(Module module) {
        this.tableHeader = new ReplacementTableHeader(module);
        this.tableRows = new HashSet<ReplacementTableRow>();
        this.ECM = EClassifierInfoManagement.getInstance();
        this.fillRows(this.tableHeader);
    }

    public void printTable() {
        System.out.println("---------------------------------");
        int ni = 0;
        while (ni < this.tableHeader.size()) {
            System.out.print("[" + ni + "]" + this.tableHeader.get(ni).getType().getName() + " ");
            ++ni;
        }
        System.out.println("\n");
        for (ReplacementTableRow row : this.tableRows) {
            int i = 0;
            while (i < row.size()) {
                if (row.get(i) == null) {
                    System.out.print(" [" + i + "]-");
                } else {
                    System.out.print(" [" + i + "]" + row.get(i).getName());
                }
                ++i;
            }
            System.out.print("\n");
        }
        System.out.print("\n");
    }

    public boolean hasReplacements() {
        return !this.tableHeader.isEmpty();
    }

    public ReplacementTableHeader getHeader() {
        return this.tableHeader;
    }

    public Set<ReplacementTableRow> getRows() {
        return this.tableRows;
    }

    private void fillRows(ReplacementTableHeader tableHeader) {
        if (tableHeader.isEmpty()) {
            return;
        }
        Node initialNode = tableHeader.firstElement();
        EClass initialNodeType = initialNode.getType();
        HashSet replacements = new HashSet();
        replacements.addAll(this.ECM.getAllConcreteEClassifiersForAbstract((EClassifier)initialNodeType));
        replacements.addAll(this.ECM.getAllSubTypesAsEClassifiersWithoutAbstracts((EClassifier)initialNodeType));
        for (EClassifier initRepl : replacements) {
            ReplacementTableRow newRow = new ReplacementTableRow();
            newRow.insertElementAt(initRepl, 0);
            this.tableRows.add(newRow);
        }
        int i = 1;
        while (i < tableHeader.size()) {
            Node nextNode = tableHeader.get(i);
            EClass nextNodeType = nextNode.getType();
            HashSet nextReplacements = new HashSet();
            nextReplacements.addAll(this.ECM.getAllConcreteEClassifiersForAbstract((EClassifier)nextNodeType));
            nextReplacements.addAll(this.ECM.getAllSubTypesAsEClassifiersWithoutAbstracts((EClassifier)nextNodeType));
            Iterator<ReplacementTableRow> it = this.tableRows.iterator();
            if (nextReplacements.size() == 1) {
                EClassifier singleReplacement = (EClassifier)nextReplacements.iterator().next();
                while (it.hasNext()) {
                    ReplacementTableRow currentRow = it.next();
                    currentRow.ensureCapacity(i);
                    currentRow.insertElementAt(singleReplacement, i);
                }
            } else if (nextReplacements.size() > 1) {
                HashSet<ReplacementTableRow> newRows = new HashSet<ReplacementTableRow>();
                for (EClassifier nextReplace : nextReplacements) {
                    while (it.hasNext()) {
                        ReplacementTableRow currentRow = it.next();
                        currentRow.ensureCapacity(i);
                        currentRow.insertElementAt(nextReplace, i);
                        ReplacementTableRow copy = this.copy(currentRow);
                        copy.set(nextReplace, i);
                        newRows.add(copy);
                    }
                }
                this.tableRows.addAll(newRows);
            }
            ++i;
        }
    }

    private ReplacementTableRow copy(ReplacementTableRow row) {
        ReplacementTableRow copy = new ReplacementTableRow();
        int i = 0;
        while (i < row.size()) {
            copy.insertElementAt(row.get(i), i);
            ++i;
        }
        return copy;
    }
}

