/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.model.Module;

public class NameMapper {
    private List<NameMapping> mappings;
    private Map<String, Module> moduleIndex;

    public NameMapper(EPackage metaModel, Set<Module> allModules) {
        this.mappings = new ArrayList<NameMapping>(allModules.size());
        if (metaModel.getNsURI().equals(EcorePackage.eINSTANCE.getNsURI())) {
            this.initEcoreNameMappings();
        }
        if (metaModel.getNsURI().equals("http://SA/1.0")) {
            this.initSAMappings();
        }
        if (metaModel.getNsURI().equals("http://FaultTree/1.0")) {
            this.initFTMappings();
        }
        this.moduleIndex = new HashMap<String, Module>();
        for (Module module : allModules) {
            this.moduleIndex.put(module.getName(), module);
        }
    }

    public void replaceNames() {
        for (NameMapping mapping : this.mappings) {
            Module module = this.moduleIndex.get(mapping.generatedName);
            if (module == null) continue;
            module.setName(mapping.manualName);
        }
    }

    private void initEcoreNameMappings() {
        this.mappings.add(new NameMapping("<gen-name>", "<understandable-name>"));
    }

    private void initSAMappings() {
        this.mappings.add(new NameMapping("CHANGE_REFERENCE_ComponentInstance_(type)_TGT_ComponentType", "changeTypeOfComponent"));
        this.mappings.add(new NameMapping("CHANGE_REFERENCE_Connector_(port)_TGT_PortInstance", "changePortOfConnector"));
        this.mappings.add(new NameMapping("CHANGE_REFERENCE_PortInstance_(type)_TGT_PortType", "changeTypeOfPort"));
        this.mappings.add(new NameMapping("CREATE_Actuator_IN_Architecture_(component)", "createActuator"));
        this.mappings.add(new NameMapping("CREATE_ComponentInstance_IN_Architecture_(instances)", "createComponent"));
        this.mappings.add(new NameMapping("CREATE_ComponentInstance_IN_ComponentInstance_(subcomponent)", "createSubComponent"));
        this.mappings.add(new NameMapping("CREATE_ComponentType_IN_Architecture_(component)", "createComponentType"));
        this.mappings.add(new NameMapping("CREATE_Connector_IN_Architecture_(connectors)", "createConnector"));
        this.mappings.add(new NameMapping("CREATE_ElectronicDevice_IN_Architecture_(component)", "createElectronicDevice"));
        this.mappings.add(new NameMapping("CREATE_HardwareComponent_IN_Architecture_(component)", "createHardwareComponent"));
        this.mappings.add(new NameMapping("CREATE_MechanicalDevice_IN_Architecture_(component)", "createMechanicalDevice"));
        this.mappings.add(new NameMapping("CREATE_PortInstance_IN_ComponentInstance_(inPorts)", "createInPort"));
        this.mappings.add(new NameMapping("CREATE_PortInstance_IN_ComponentInstance_(outPorts)", "createOutPort"));
        this.mappings.add(new NameMapping("CREATE_PortType_IN_ComponentType_(port_types)", "createPortType"));
        this.mappings.add(new NameMapping("CREATE_Sensor_IN_Architecture_(component)", "createSensor"));
        this.mappings.add(new NameMapping("CREATE_SoftwareComponent_IN_Architecture_(component)", "createSoftwareComponent"));
        this.mappings.add(new NameMapping("DELETE_Actuator_IN_Architecture_(component)", "deleteActuator"));
        this.mappings.add(new NameMapping("DELETE_ComponentInstance_IN_Architecture_(instances)", "deleteComponent"));
        this.mappings.add(new NameMapping("DELETE_ComponentInstance_IN_ComponentInstance_(subcomponent)", "deleteSubComponent"));
        this.mappings.add(new NameMapping("DELETE_ComponentType_IN_Architecture_(component)", "deleteComponentType"));
        this.mappings.add(new NameMapping("DELETE_Connector_IN_Architecture_(connectors)", "deleteConnector"));
        this.mappings.add(new NameMapping("DELETE_ElectronicDevice_IN_Architecture_(component)", "deleteElectronicDevice"));
        this.mappings.add(new NameMapping("DELETE_HardwareComponent_IN_Architecture_(component)", "deleteHardwareComponent"));
        this.mappings.add(new NameMapping("DELETE_MechanicalDevice_IN_Architecture_(component)", "deleteMechanicalDevice"));
        this.mappings.add(new NameMapping("DELETE_PortInstance_IN_ComponentInstance_(inPorts)", "deleteInPort"));
        this.mappings.add(new NameMapping("DELETE_PortInstance_IN_ComponentInstance_(outPorts)", "deleteOutPort"));
        this.mappings.add(new NameMapping("DELETE_PortType_IN_ComponentType_(port_types)", "deletePortType"));
        this.mappings.add(new NameMapping("DELETE_Sensor_IN_Architecture_(component)", "deleteSensor"));
        this.mappings.add(new NameMapping("DELETE_SoftwareComponent_IN_Architecture_(component)", "deleteSoftwareComponent"));
        this.mappings.add(new NameMapping("MOVE_ComponentInstance_FROM_ComponentInstance_(subcomponent)_TO_ComponentInstance_(subcomponent)", "moveComponent"));
        this.mappings.add(new NameMapping("MOVE_REF_COMBI_ComponentInstance_FROM_Architecture_(instances)_TO_ComponentInstance_(subcomponent)", "convertComponentToSubComponent"));
        this.mappings.add(new NameMapping("MOVE_REF_COMBI_ComponentInstance_FROM_ComponentInstance_(subcomponent)_TO_Architecture_(subcomponent)", "moveSubComponentToArchitecture"));
        this.mappings.add(new NameMapping("MOVE_PortInstance_FROM_ComponentInstance_(inPorts)_TO_ComponentInstance_(inPorts)", "moveInPort"));
        this.mappings.add(new NameMapping("MOVE_PortInstance_FROM_ComponentInstance_(outPorts)_TO_ComponentInstance_(outPorts)", "moveOutPort"));
        this.mappings.add(new NameMapping("MOVE_PortType_FROM_ComponentType_(port_types)_TO_ComponentType_(port_types)", "changeComponentTypeOfPortType"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Actuator_Name", "setActuatorName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Actuator_PowerSupply", "setActuatorPowerSupply"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ComponentInstance_Name", "setComponentName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ComponentInstance_Version", "setComponentVersion"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ComponentType_Name", "setComponentTypeName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Connector_Name", "setConnectorName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ElectronicDevice_Name", "setElectronicDeviceName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ElectronicDevice_PowerSupply", "setElectronicDevicePowerSupply"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_HardwareComponent_Name", "setHardwareComponentName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_HardwareComponent_PowerSupply", "setHardwareComponentPowerSupply"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_MechanicalDevice_Name", "setMechanicalDeviceName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_MechanicalDevice_PowerSupply", "setMechanicalDevicePowerSupply"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_PortInstance_Name", "setPortName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_PortType_Name", "setPortTypeName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Sensor_Name", "setSensorName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Sensor_PowerSupply", "setSensorPowerSupply"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Sensor_Type", "setSensorType"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_SoftwareComponent_Name", "setSoftwareComponentName"));
    }

    private void initFTMappings() {
        this.mappings.add(new NameMapping("ADD_BasicEvent_(instance)_TGT_ErrorInstance", "addErrorToBasicEvent"));
        this.mappings.add(new NameMapping("ADD_Gate_(inputEvents)_TGT_Event", "addInputEventToGate"));
        this.mappings.add(new NameMapping("ADD_Gate_(inputGates)_TGT_Gate", "addInputGateToGate"));
        this.mappings.add(new NameMapping("ADD_IntermediateEvent_(instance)_TGT_FailureInstance", "addFailureToIntermediateEvent"));
        this.mappings.add(new NameMapping("CHANGE_REFERENCE_ErrorInstance_(type)_TGT_ErrorType", "changeTypeOfError"));
        this.mappings.add(new NameMapping("CHANGE_REFERENCE_FailureInstance_(type)_TGT_FailureType", "changeTypeOfFailure"));
        this.mappings.add(new NameMapping("CREATE_AND_IN_Root_(gate)", "createAND"));
        this.mappings.add(new NameMapping("CREATE_BasicEvent_IN_Root_(event)", "createBasicEvent"));
        this.mappings.add(new NameMapping("CREATE_ErrorInstance_IN_Root_(error_instance)", "createError"));
        this.mappings.add(new NameMapping("CREATE_ErrorType_IN_Root_(error_type)", "createErrorType"));
        this.mappings.add(new NameMapping("CREATE_FailureInstance_IN_Root_(failure_instance)", "createFailure"));
        this.mappings.add(new NameMapping("CREATE_FailureType_IN_Root_(failure_type)", "createFailureType"));
        this.mappings.add(new NameMapping("CREATE_Hazard_IN_Root_(hazard)", "createHazard"));
        this.mappings.add(new NameMapping("CREATE_Inhibit_IN_Root_(gate)", "createInhibit"));
        this.mappings.add(new NameMapping("CREATE_IntermediateEvent_IN_Root_(event)", "createIntermediateEvent"));
        this.mappings.add(new NameMapping("CREATE_OR_IN_Root_(gate)", "createOR"));
        this.mappings.add(new NameMapping("CREATE_PriorAND_IN_Root_(gate)", "createPriorAND"));
        this.mappings.add(new NameMapping("CREATE_UndevelopedEvent_IN_Root_(event)", "createUndevelopedEvent"));
        this.mappings.add(new NameMapping("CREATE_XOR_IN_Root_(gate)", "createXOR"));
        this.mappings.add(new NameMapping("DELETE_AND_IN_Root_(gate)", "deleteAND"));
        this.mappings.add(new NameMapping("DELETE_BasicEvent_IN_Root_(event)", "deleteBasicEvent"));
        this.mappings.add(new NameMapping("DELETE_ErrorInstance_IN_Root_(error_instance)", "deleteError"));
        this.mappings.add(new NameMapping("DELETE_ErrorType_IN_Root_(error_type)", "deleteErrorType"));
        this.mappings.add(new NameMapping("DELETE_FailureInstance_IN_Root_(failure_instance)", "deleteFailure"));
        this.mappings.add(new NameMapping("DELETE_FailureType_IN_Root_(failure_type)", "deleteFailureType"));
        this.mappings.add(new NameMapping("DELETE_Hazard_IN_Root_(hazard)", "deleteHazard"));
        this.mappings.add(new NameMapping("DELETE_Inhibit_IN_Root_(gate)", "deleteInhibit"));
        this.mappings.add(new NameMapping("DELETE_IntermediateEvent_IN_Root_(event)", "deleteIntermediateEvent"));
        this.mappings.add(new NameMapping("DELETE_OR_IN_Root_(gate)", "deleteOR"));
        this.mappings.add(new NameMapping("DELETE_PriorAND_IN_Root_(gate)", "deletePriorAND"));
        this.mappings.add(new NameMapping("DELETE_UndevelopedEvent_IN_Root_(event)", "deleteUndevelopedEvent"));
        this.mappings.add(new NameMapping("DELETE_XOR_IN_Root_(gate)", "deleteXOR"));
        this.mappings.add(new NameMapping("REMOVE_BasicEvent_(instance)_TGT_ErrorInstance", "removeErrorFromBasicEvent"));
        this.mappings.add(new NameMapping("REMOVE_Gate_(inputEvents)_TGT_Event", "removeInputEventFromGate"));
        this.mappings.add(new NameMapping("REMOVE_Gate_(inputGates)_TGT_Gate", "removeInputGateFromGate"));
        this.mappings.add(new NameMapping("REMOVE_IntermediateEvent_(instance)_TGT_FailureInstance", "removeFailureFromIntermediateEvent"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_BasicEvent_Probability", "setBasicEventProbability"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ErrorInstance_Name", "setErrorName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_ErrorType_Name", "setErrorTypeName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Event_Description", "setEventDescription"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Event_Id", "setEventId"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Event_Name", "setEventName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_FailureInstance_Name", "setFailureName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_FailureType_Name", "setFailureTypeName"));
        this.mappings.add(new NameMapping("SET_ATTRIBUTE_Gate_Id", "setGateId"));
        this.mappings.add(new NameMapping("SET_REFERENCE_BasicEvent_(outEvent)_TGT_IntermediateEvent", "setBasicEventOutEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_ErrorInstance_(error)_TGT_BasicEvent", "setErrorEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_Event_(inputGate)_TGT_Gate", "setEventInputGate"));
        this.mappings.add(new NameMapping("SET_REFERENCE_Event_(outputGate)_TGT_Gate", "setEventOutputGate"));
        this.mappings.add(new NameMapping("SET_REFERENCE_FailureInstance_(event)_TGT_IntermediateEvent", "setFailureEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_FailureInstance_(previousError)_TGT_ErrorInstance", "setFailurePreviousError"));
        this.mappings.add(new NameMapping("SET_REFERENCE_FailureInstance_(previousFailure)_TGT_FailureInstance", "setFailurePreviousFailure"));
        this.mappings.add(new NameMapping("SET_REFERENCE_Gate_(outputEvent)_TGT_Event", "setGateOutputEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_Gate_(outputGate)_TGT_Gate", "setGateOutputGate"));
        this.mappings.add(new NameMapping("SET_REFERENCE_Hazard_(inEvent)_TGT_IntermediateEvent", "setHazardInEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_IntermediateEvent_(inEvent)_TGT_Event", "setIntermediateEventInEvent"));
        this.mappings.add(new NameMapping("SET_REFERENCE_IntermediateEvent_(outEvent)_TGT_Event", "setIntermediateEventOutEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_BasicEvent_(outEvent)_TGT_IntermediateEvent", "unsetBasicEventOutEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_ErrorInstance_(error)_TGT_BasicEvent", "unsetErrorEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_Event_(inputGate)_TGT_Gate", "unsetEventInputGate"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_Event_(outputGate)_TGT_Gate", "unsetEventOutputGate"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_FailureInstance_(event)_TGT_IntermediateEvent", "unsetFailureEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_FailureInstance_(previousError)_TGT_ErrorInstance", "unsetFailurePreviousError"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_FailureInstance_(previousFailure)_TGT_FailureInstance", "unsetFailurePreviousFailure"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_Gate_(outputEvent)_TGT_Event", "unsetGateOutputEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_Gate_(outputGate)_TGT_Gate", "unsetGateOutputGate"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_Hazard_(inEvent)_TGT_IntermediateEvent", "unsetHazardInEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_IntermediateEvent_(inEvent)_TGT_Event", "unsetIntermediateEventInEvent"));
        this.mappings.add(new NameMapping("UNSET_REFERENCE_IntermediateEvent_(outEvent)_TGT_Event", "unsetIntermediateEventOutEvent"));
    }

    class NameMapping {
        String generatedName;
        String manualName;

        NameMapping(String generatedName, String manualName) {
            this.generatedName = generatedName;
            this.manualName = manualName;
        }
    }
}

