/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.settings.SergeSettings;
import org.sidiff.editrule.generator.types.OperationType;

public class ModuleSerializer {
    private SergeSettings settings = null;
    private Configuration config = Configuration.getInstance();
    private FilenameFilter henshinFileNameFilter = null;

    public ModuleSerializer(SergeSettings settings) {
        this.settings = settings;
        this.henshinFileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File f, String fileName) {
                return fileName.endsWith(".henshin") || fileName.endsWith(".henshin_diagram");
            }
        };
    }

    private void serialize(Module module) throws OperationTypeNotImplementedException {
        File folder;
        String outputFolderPath = String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator");
        String moduleFileName = String.valueOf(module.getName()) + "_execute.henshin";
        if (this.settings.isUseSubfolders()) {
            outputFolderPath = String.valueOf(outputFolderPath) + this.findFittingSubfolderName(module);
        }
        this.checkModuleFileNameEquality(module, moduleFileName);
        this.checkMainUnitIsUnique(module);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileUri = URI.createFileURI((String)(String.valueOf(outputFolderPath) + moduleFileName));
        if (!this.settings.isOverwriteGeneratedTransformations() && (folder = new File(outputFolderPath)).isDirectory()) {
            File[] fileArray = folder.listFiles(this.henshinFileNameFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (module.getName().concat("_execute.henshin").equals(f.getName())) {
                    LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Already exists: " + module.getName() + "  Overwriting was disabled. Thus serialization for this module will be skipped. "});
                    return;
                }
                ++n2;
            }
        }
        Resource resource = resourceSet.createResource(fileUri);
        resource.getContents().add((Object)module);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("SCHEMA_LOCATION", true);
        try {
            LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"Save: " + resource.getURI()});
            resource.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkModuleFileNameEquality(Module module, String outputFileName) {
        String name = outputFileName.replace("_execute.henshin", "");
        name = name.replace("_initialcheck.henshin", "");
        String[] splitName = null;
        String separator = System.getProperty("file.separator");
        splitName = separator.equals("\\") ? name.split("\\" + System.getProperty("file.separator")) : name.split(System.getProperty("file.separator"));
        name = splitName[splitName.length - 1];
        assert (module.getName().equals(name)) : "Output file name and Module name are not equal.";
    }

    private void checkMainUnitIsUnique(Module module) {
        int mainUnitCount = 0;
        for (Unit unit : module.getUnits()) {
            if (unit instanceof Rule) continue;
            if (unit.getName().equals("mainUnit")) {
                ++mainUnitCount;
            }
            for (Unit subUnit : unit.getSubUnits(true)) {
                if (subUnit instanceof Rule || !subUnit.getName().equals("mainUnit")) continue;
                ++mainUnitCount;
            }
        }
        assert (mainUnitCount == 1) : "Multiple or no main units in Module " + module.getName() + ". Should be exactly one";
    }

    public void serialize(Set<Module> allModules) throws OperationTypeNotImplementedException {
        if (this.settings.isDeleteGeneratedTransformations()) {
            String outputFolderPath = String.valueOf(this.settings.getOutputFolderPath()) + System.getProperty("file.separator");
            ArrayList<String> folderPaths = new ArrayList<String>();
            folderPaths.add(outputFolderPath);
            if (this.settings.isUseSubfolders()) {
                folderPaths.add(String.valueOf(outputFolderPath) + "CREATE");
                folderPaths.add(String.valueOf(outputFolderPath) + "DELETE");
                folderPaths.add(String.valueOf(outputFolderPath) + "MOVE");
                folderPaths.add(String.valueOf(outputFolderPath) + "SET");
                folderPaths.add(String.valueOf(outputFolderPath) + "UNSET");
                folderPaths.add(String.valueOf(outputFolderPath) + "CHANGE");
                folderPaths.add(String.valueOf(outputFolderPath) + "ADD");
                folderPaths.add(String.valueOf(outputFolderPath) + "REMOVE");
            }
            for (String folderPath : folderPaths) {
                File[] henshinFiles;
                File folder = new File(folderPath);
                if (!folder.exists()) continue;
                File[] fileArray = henshinFiles = folder.listFiles(this.henshinFileNameFilter);
                int n = henshinFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
        }
        for (Module module : allModules) {
            this.serialize(module);
        }
    }

    private String findFittingSubfolderName(Module module) throws OperationTypeNotImplementedException {
        String expectedSubfolderName = "";
        if (this.config.CREATE_CREATES && (module.getName().startsWith("CREATE_") || module.getName().startsWith("create"))) {
            expectedSubfolderName = "CREATE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_DELETES && (module.getName().startsWith("DELETE_") || module.getName().startsWith("delete"))) {
            expectedSubfolderName = "DELETE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_MOVES && (module.getName().startsWith("MOVE_") || module.getName().startsWith("move"))) {
            expectedSubfolderName = "MOVE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_MOVE_REFERENCE_COMBINATIONS && (module.getName().startsWith("MOVE_REF_COMBI_") || module.getName().startsWith("move"))) {
            expectedSubfolderName = "MOVE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_MOVE_UPS && (module.getName().startsWith("MOVE_UP_") || module.getName().startsWith("move"))) {
            expectedSubfolderName = "MOVE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_MOVE_DOWNS && (module.getName().startsWith("MOVE_DOWN_") || module.getName().startsWith("move"))) {
            expectedSubfolderName = "MOVE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_SET_ATTRIBUTES && (module.getName().startsWith("SET_ATTRIBUTE_") || module.getName().startsWith("set"))) {
            expectedSubfolderName = "SET" + System.getProperty("file.separator");
        } else if (this.config.CREATE_SET_REFERENCES && (module.getName().startsWith("SET_REFERENCE_") || module.getName().startsWith("set"))) {
            expectedSubfolderName = "SET" + System.getProperty("file.separator");
        } else if (this.config.CREATE_UNSET_ATTRIBUTES && (module.getName().startsWith("UNSET_ATTRIBUTE_") || module.getName().startsWith("unset"))) {
            expectedSubfolderName = "UNSET" + System.getProperty("file.separator");
        } else if (this.config.CREATE_UNSET_REFERENCES && (module.getName().startsWith("UNSET_REFERENCE_") || module.getName().startsWith("unset"))) {
            expectedSubfolderName = "UNSET" + System.getProperty("file.separator");
        } else if (this.config.CREATE_CHANGE_LITERALS && (module.getName().startsWith("CHANGE_LITERAL_") || module.getName().startsWith("change"))) {
            expectedSubfolderName = "CHANGE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_CHANGE_REFERENCES && (module.getName().startsWith("CHANGE_REFERENCE_") || module.getName().startsWith("change"))) {
            expectedSubfolderName = "CHANGE" + System.getProperty("file.separator");
        } else if (this.config.CREATE_ADDS && (module.getName().startsWith("ADD_") || module.getName().startsWith("add"))) {
            expectedSubfolderName = "ADD" + System.getProperty("file.separator");
        } else if (this.config.CREATE_REMOVES && (module.getName().startsWith("REMOVE_") || module.getName().startsWith("remove"))) {
            expectedSubfolderName = "REMOVE" + System.getProperty("file.separator");
        } else {
            throw new OperationTypeNotImplementedException(OperationType.UNKNOWN);
        }
        return expectedSubfolderName;
    }
}

