/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.sidiff.common.emf.extensions.impl.EClassifierInfo;
import org.sidiff.common.emf.extensions.impl.EClassifierInfoManagement;
import org.sidiff.common.henshin.HenshinRuleAnalysisUtilEx;
import org.sidiff.common.henshin.NodePair;
import org.sidiff.editrule.generator.exceptions.OperationTypeNotImplementedException;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.filter.ElementFilter;
import org.sidiff.editrule.generator.types.OperationType;

public class ModuleInternalsApplicator {
    public static Rule createBasicRule(Module module, EReference eRefA, EClassifier eClassifier, EClassifier targetA, EReference eRefB, EClassifier targetB, OperationType opType) throws OperationTypeNotImplementedException {
        Rule rule = null;
        NodePair selectedNodePair = null;
        NodePair newNodePair = null;
        NodePair oldNodePair = null;
        Node rhsNode = null;
        switch (opType) {
            case SET_REFERENCE: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("set" + eClassifier.getName() + "_" + eRefA.getName() + "_TO_" + targetA.getName());
                rule.setDescription("Set" + eClassifier.getName() + "Ref" + eRefA.getName() + "To" + targetA.getName());
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                rhsNode = selectedNodePair.getRhsNode();
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewTarget", (EClass)((EClass)targetA));
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)rhsNode, (Node)newNodePair.getRhsNode(), (EReference)eRefA);
                break;
            }
            case CHANGE_REFERENCE: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("change" + eClassifier.getName() + "_" + eRefA.getName() + "_TO_" + targetA.getName());
                rule.setDescription("Change the EReference " + eRefA.getName());
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                oldNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"OldTarget", (EClass)((EClass)targetA));
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewTarget", (EClass)((EClass)targetA));
                HenshinRuleAnalysisUtilEx.createDeleteEdge((Node)selectedNodePair.getLhsNode(), (Node)oldNodePair.getLhsNode(), (EReference)eRefA, (Rule)rule);
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)selectedNodePair.getRhsNode(), (Node)newNodePair.getRhsNode(), (EReference)eRefA);
                break;
            }
            case MOVE: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("move" + eClassifier.getName() + "_FROM_" + targetA.getName() + "_" + eRefA.getName() + "_TO_" + targetB.getName() + "_" + targetB.getName());
                rule.setDescription("Moves " + eClassifier.getName() + " from " + targetA.getName() + "(Reference:" + eRefA.getName() + ") to" + targetB.getName() + "(Reference:" + targetB.getName() + ")");
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                oldNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"OldSource", (EClass)((EClass)targetA));
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewSource", (EClass)((EClass)targetB));
                HenshinRuleAnalysisUtilEx.createDeleteEdge((Node)oldNodePair.getLhsNode(), (Node)selectedNodePair.getLhsNode(), (EReference)eRefA, (Rule)rule);
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)newNodePair.getRhsNode(), (Node)selectedNodePair.getRhsNode(), (EReference)eRefB);
                break;
            }
            case MOVE_UP: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("moveUp" + eClassifier.getName() + "_FROM_" + targetA.getName() + "_" + eRefA.getName() + "_TO_" + targetB.getName() + "_" + targetB.getName());
                rule.setDescription("Moves up " + eClassifier.getName() + " from " + targetA.getName() + "(Reference:" + eRefA.getName() + ") to" + targetB.getName() + "(Reference:" + targetB.getName() + ")");
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                oldNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"OldSource", (EClass)((EClass)targetA));
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewSource", (EClass)((EClass)targetB));
                HenshinRuleAnalysisUtilEx.createDeleteEdge((Node)oldNodePair.getLhsNode(), (Node)selectedNodePair.getLhsNode(), (EReference)eRefA, (Rule)rule);
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)newNodePair.getRhsNode(), (Node)selectedNodePair.getRhsNode(), (EReference)eRefB);
                break;
            }
            case MOVE_DOWN: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("moveDown" + eClassifier.getName() + "_FROM_" + targetA.getName() + "_" + eRefA.getName() + "_TO_" + targetB.getName() + "_" + targetB.getName());
                rule.setDescription("Moves down " + eClassifier.getName() + " from " + targetA.getName() + "(Reference:" + eRefA.getName() + ") to" + targetB.getName() + "(Reference:" + targetB.getName() + ")");
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                oldNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"OldSource", (EClass)((EClass)targetA));
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewSource", (EClass)((EClass)targetB));
                HenshinRuleAnalysisUtilEx.createDeleteEdge((Node)oldNodePair.getLhsNode(), (Node)selectedNodePair.getLhsNode(), (EReference)eRefA, (Rule)rule);
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)newNodePair.getRhsNode(), (Node)selectedNodePair.getRhsNode(), (EReference)eRefB);
                break;
            }
            case MOVE_REFERENCE_COMBINATION: {
                rule = HenshinFactory.eINSTANCE.createRule();
                rule.setActivated(true);
                rule.setName("move" + eClassifier.getName() + "_FROM_" + targetA.getName() + "_" + eRefA.getName() + "_TO_" + targetB.getName() + "_" + targetB.getName());
                rule.setDescription("Moves " + eClassifier.getName() + " from " + targetA.getName() + "(Reference:" + eRefA.getName() + ") to" + targetB.getName() + "(Reference:" + targetB.getName() + ")");
                module.getUnits().add((Object)rule);
                selectedNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"Selected", (EClass)((EClass)eClassifier));
                oldNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"OldSource", (EClass)((EClass)targetA));
                newNodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)"NewSource", (EClass)((EClass)targetB));
                HenshinRuleAnalysisUtilEx.createDeleteEdge((Node)oldNodePair.getLhsNode(), (Node)selectedNodePair.getLhsNode(), (EReference)eRefA, (Rule)rule);
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)newNodePair.getRhsNode(), (Node)selectedNodePair.getRhsNode(), (EReference)eRefB);
                break;
            }
            case CREATE: {
                if (targetA != null) {
                    String contextName = ModuleInternalsApplicator.toCamelCase(targetA.getName());
                    rule = HenshinRuleAnalysisUtilEx.createRule((String)("create" + eClassifier.getName() + "_IN_" + contextName), (String)("creates one " + eClassifier.getName() + " in the context: " + contextName), (Boolean)true, (Module)module);
                    String selectedName = ModuleInternalsApplicator.getFreeNodeName("Selected", rule);
                    NodePair nodePair = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)selectedName, (EClass)((EClass)targetA));
                    Graph rhs = nodePair.getRhsNode().getGraph();
                    String newName = ModuleInternalsApplicator.getFreeNodeName("New", rule);
                    Node newNode = HenshinRuleAnalysisUtilEx.createCreateNode((Graph)rhs, (String)newName, (EClass)((EClass)eClassifier));
                    ModuleInternalsApplicator.createAttributes((EClass)eClassifier, newNode, rule);
                    if (targetA == null || eRefA == null) break;
                    Node contextNode = null;
                    for (Node n : rhs.getNodes()) {
                        String nName = n.getName();
                        if (nName == null || !nName.equals(selectedName)) continue;
                        contextNode = n;
                    }
                    HenshinRuleAnalysisUtilEx.createCreateEdge(contextNode, (Node)newNode, (EReference)eRefA);
                    break;
                }
                rule = HenshinRuleAnalysisUtilEx.createRule((String)("create" + eClassifier.getName()), (String)("creates one " + eClassifier.getName()), (Boolean)true, (Module)module);
                String newName = ModuleInternalsApplicator.getFreeNodeName("New", rule);
                Graph rhs = rule.getRhs();
                Node newNode = HenshinRuleAnalysisUtilEx.createCreateNode((Graph)rhs, (String)newName, (EClass)((EClass)eClassifier));
                ModuleInternalsApplicator.createAttributes((EClass)eClassifier, newNode, rule);
                break;
            }
            default: {
                throw new OperationTypeNotImplementedException(opType);
            }
        }
        return rule;
    }

    public static void createMandatoryChildren(Rule rule, EClassifierInfo eClassifierInfo, Node eClassifierNode, OperationType opType, boolean reduceToSuperType) throws OperationTypeNotImplementedException {
        for (Map.Entry childEntry : eClassifierInfo.getMandatoryChildren().entrySet()) {
            EReference eRef = (EReference)childEntry.getKey();
            EClassifier child = eRef.getEType();
            if (!ElementFilter.getInstance().isAllowedAsDangling(child, opType, reduceToSuperType).booleanValue()) continue;
            int i = 0;
            while (i < eRef.getLowerBound()) {
                Node newChildNode = null;
                String name = ModuleInternalsApplicator.getFreeNodeName("Child", rule);
                newChildNode = HenshinRuleAnalysisUtilEx.createCreateNode((Graph)rule.getRhs(), (String)name, (EClass)((EClass)child));
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)eClassifierNode, (Node)newChildNode, (EReference)eRef);
                ModuleInternalsApplicator.createAttributes((EClass)child, newChildNode, rule);
                if (EClassifierInfoManagement.getInstance().getEClassifierInfo(child).hasMandatories()) {
                    ModuleInternalsApplicator.createMandatoryChildren(rule, EClassifierInfoManagement.getInstance().getEClassifierInfo(child), newChildNode, opType, reduceToSuperType);
                    ModuleInternalsApplicator.createMandatoryNeighbours(rule, EClassifierInfoManagement.getInstance().getEClassifierInfo(child), newChildNode, opType, reduceToSuperType);
                }
                ++i;
            }
        }
    }

    public static void createMandatoryNeighbours(Rule rule, EClassifierInfo eClassifierInfo, Node eClassifierNode, OperationType opType, boolean reduceToSuperType) throws OperationTypeNotImplementedException {
        assert (HenshinRuleAnalysisUtilEx.isCreationNode((Node)eClassifierNode));
        for (Map.Entry neighbourEntry : eClassifierInfo.getMandatoryNeighbours().entrySet()) {
            EReference eRef = (EReference)neighbourEntry.getKey();
            EReference eOpposite = eRef.getEOpposite();
            EList incEOpposites = eClassifierNode.getIncoming(eOpposite);
            if (!incEOpposites.isEmpty()) {
                int currentIncomings = incEOpposites.size();
                if (eRef.getUpperBound() == currentIncomings) continue;
            }
            assert (eRef.getLowerBound() > 0);
            EClass neighbour = eRef.getEReferenceType();
            if (!ElementFilter.getInstance().isAllowedAsDangling((EClassifier)neighbour, opType, reduceToSuperType).booleanValue()) continue;
            int i = 0;
            while (i < eRef.getLowerBound()) {
                String existingName = ModuleInternalsApplicator.getFreeNodeName("Existing", rule);
                NodePair preservedNeighbour = HenshinRuleAnalysisUtilEx.createPreservedNode((Rule)rule, (String)existingName, (EClass)neighbour);
                Node rhsNeighbour = preservedNeighbour.getRhsNode();
                HenshinRuleAnalysisUtilEx.createCreateEdge((Node)eClassifierNode, (Node)rhsNeighbour, (EReference)eRef);
                ++i;
            }
        }
    }

    public static String toCamelCase(String s) {
        if (Character.isLetter(s.charAt(0))) {
            char c = s.charAt(0);
            return s.replaceFirst(String.valueOf(c), String.valueOf(c).toUpperCase());
        }
        return s;
    }

    private static String getFreeAttributeName(String originalName, Rule rule) {
        originalName = ModuleInternalsApplicator.toCamelCase(originalName);
        List allCreateAttributes = HenshinRuleAnalysisUtilEx.getCreationAttributes((Rule)rule);
        int count = 0;
        for (Attribute attrib : allCreateAttributes) {
            if (!attrib.getValue().startsWith(originalName)) continue;
            ++count;
        }
        if (count != 0) {
            return String.valueOf(originalName) + String.valueOf(count);
        }
        return originalName;
    }

    private static void createAttributes(EClass forEClass, Node inEClassNode, Rule rule) {
        for (EAttribute ea : forEClass.getEAllAttributes()) {
            if (ea.isDerived() || ea.isTransient() || !ea.isChangeable()) continue;
            String eaName = ModuleInternalsApplicator.getFreeAttributeName(ea.getName(), rule);
            boolean createNotRequiredAndNotIDAttributes = Configuration.getInstance().CREATE_NOT_REQUIRED_AND_NOT_ID_ATTRIBUTES;
            if (!createNotRequiredAndNotIDAttributes && (createNotRequiredAndNotIDAttributes || !ea.isRequired() && !ea.isID())) continue;
            HenshinRuleAnalysisUtilEx.createCreateAttribute((Node)inEClassNode, (EAttribute)ea, (String)ModuleInternalsApplicator.toCamelCase(ModuleInternalsApplicator.getFreeAttributeName(eaName, rule)));
        }
    }

    private static String getFreeNodeName(String originalName, Rule rule) {
        originalName = ModuleInternalsApplicator.toCamelCase(originalName);
        List allNodes = HenshinRuleAnalysisUtilEx.getLHSIntersectRHSNodes((Rule)rule);
        allNodes.addAll(HenshinRuleAnalysisUtilEx.getLHSMinusRHSNodes((Rule)rule));
        allNodes.addAll(HenshinRuleAnalysisUtilEx.getRHSMinusLHSNodes((Rule)rule));
        int count = 0;
        for (Node node : allNodes) {
            String nNode = node.getName();
            if (nNode == null || !node.getName().startsWith(originalName)) continue;
            ++count;
        }
        if (count != 0) {
            return String.valueOf(originalName) + String.valueOf(count);
        }
        return originalName;
    }
}

