/*
 * Decompiled with CFR 0.152.
 */
package org.sidiff.editrule.generator.serge.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.henshin.model.Module;
import org.sidiff.common.emf.ecore.EClassVisitor;
import org.sidiff.common.logging.LogEvent;
import org.sidiff.common.logging.LogUtil;
import org.sidiff.editrule.generator.serge.configuration.Configuration;
import org.sidiff.editrule.generator.serge.core.GenerationActionDelegator;
import org.sidiff.editrule.generator.types.OperationType;

public class MetaModelElementVisitor
implements EClassVisitor {
    private GenerationActionDelegator GAD = GenerationActionDelegator.getInstance();
    private Set<Module> allCreateModules = new HashSet<Module>();
    private Set<Module> allVariantModules = new HashSet<Module>();
    private Set<Module> allDeleteModules = new HashSet<Module>();
    private Set<Module> allMoveModules = new HashSet<Module>();
    private Set<Module> allMoveCombinationModules = new HashSet<Module>();
    private Set<Module> allMoveDownModules = new HashSet<Module>();
    private Set<Module> allMoveUpModules = new HashSet<Module>();
    private Set<Module> allAddModules = new HashSet<Module>();
    private Set<Module> allRemoveModules = new HashSet<Module>();
    private Set<Module> allSetAttributeModules = new HashSet<Module>();
    private Set<Module> allSetReferenceModules = new HashSet<Module>();
    private Set<Module> allUnsetAttributeModules = new HashSet<Module>();
    private Set<Module> allUnsetReferenceModules = new HashSet<Module>();
    private Set<Module> allChangeLiteralModules = new HashSet<Module>();
    private Set<Module> allChangeReferenceModules = new HashSet<Module>();

    public void eClassifier(EClassifier eClassifier, String fullyQualifiedPath) {
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"***** " + eClassifier.getName() + " ***********************************************"});
        assert (eClassifier instanceof EClass);
        EClass contextClass = (EClass)eClassifier;
        try {
            Set<Module> changeReferenceModules;
            Set<Module> changeLiteralModules;
            Set<Module> unsetReferenceModules;
            Set<Module> setReferenceModules;
            Set<Module> unsetAttributeModules;
            Set<Module> setAttributeModules;
            Set<Module> removeModules;
            Set<Module> addModules;
            Set<Module> moveUpModules;
            Set<Module> moveDownModules;
            Set<Module> moveCombinationModules;
            Set<Module> moveModules;
            Set<Module> deleteModules;
            Set<Module> variantModules;
            Set<Module> createModules = this.GAD.generate_CREATE((EClassifier)contextClass);
            if (!createModules.isEmpty()) {
                this.allCreateModules.addAll(createModules);
            }
            if (!(variantModules = this.GAD.process_Replacables(createModules, OperationType.CREATE, Configuration.getInstance().REDUCETOSUPERTYPE_CREATEDELETE)).isEmpty()) {
                this.allVariantModules.addAll(variantModules);
            }
            if (!(deleteModules = this.GAD.generate_DELETE(createModules)).isEmpty()) {
                this.allDeleteModules.addAll(deleteModules);
            }
            if (!(moveModules = this.GAD.generate_MOVE((EClassifier)contextClass)).isEmpty()) {
                this.allMoveModules.addAll(moveModules);
            }
            if (!(moveCombinationModules = this.GAD.generate_MOVE_REFERENCE_COMBINATION((EClassifier)contextClass)).isEmpty()) {
                this.allMoveCombinationModules.addAll(moveCombinationModules);
            }
            if (!(moveDownModules = this.GAD.generate_MOVE_DOWN((EClassifier)contextClass)).isEmpty()) {
                this.allMoveDownModules.addAll(moveDownModules);
            }
            if (!(moveUpModules = this.GAD.generate_MOVE_UP((EClassifier)contextClass)).isEmpty()) {
                this.allMoveUpModules.addAll(moveUpModules);
            }
            if (!(addModules = this.GAD.generate_ADD(contextClass)).isEmpty()) {
                this.allAddModules.addAll(addModules);
            }
            if (!(removeModules = this.GAD.generate_REMOVE(addModules)).isEmpty()) {
                this.allRemoveModules.addAll(removeModules);
            }
            if (!(setAttributeModules = this.GAD.generate_SET_ATTRIBUTE((EClassifier)contextClass)).isEmpty()) {
                this.allSetAttributeModules.addAll(setAttributeModules);
            }
            if (!(unsetAttributeModules = this.GAD.generate_UNSET_ATTRIBUTE(setAttributeModules)).isEmpty()) {
                this.allUnsetAttributeModules.addAll(unsetAttributeModules);
            }
            if (!(setReferenceModules = this.GAD.generate_SET_REFERENCE(contextClass)).isEmpty()) {
                this.allSetReferenceModules.addAll(setReferenceModules);
            }
            if (!(unsetReferenceModules = this.GAD.generate_UNSET_REFERENCE(setReferenceModules)).isEmpty()) {
                this.allUnsetReferenceModules.addAll(unsetReferenceModules);
            }
            if (!(changeLiteralModules = this.GAD.generate_CHANGE_Literals((EClassifier)contextClass)).isEmpty()) {
                this.allChangeLiteralModules.addAll(changeLiteralModules);
            }
            if (!(changeReferenceModules = this.GAD.generate_CHANGE_Reference(contextClass)).isEmpty()) {
                this.allChangeReferenceModules.addAll(changeReferenceModules);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        LogUtil.log((LogEvent)LogEvent.NOTICE, (Object[])new Object[]{"finished"});
    }

    public Map<OperationType, Set<Module>> getAllModules() {
        HashMap<OperationType, Set<Module>> allModules = new HashMap<OperationType, Set<Module>>();
        allModules.put(OperationType.CREATE, this.allCreateModules);
        ((Set)allModules.get(OperationType.CREATE)).addAll(this.allVariantModules);
        allModules.put(OperationType.DELETE, this.allDeleteModules);
        allModules.put(OperationType.MOVE, this.allMoveModules);
        allModules.put(OperationType.MOVE_REFERENCE_COMBINATION, this.allMoveCombinationModules);
        allModules.put(OperationType.MOVE_UP, this.allMoveUpModules);
        allModules.put(OperationType.MOVE_DOWN, this.allMoveDownModules);
        allModules.put(OperationType.ADD, this.allAddModules);
        allModules.put(OperationType.REMOVE, this.allRemoveModules);
        allModules.put(OperationType.SET_ATTRIBUTE, this.allSetAttributeModules);
        allModules.put(OperationType.UNSET_ATTRIBUTE, this.allUnsetAttributeModules);
        allModules.put(OperationType.SET_REFERENCE, this.allSetReferenceModules);
        allModules.put(OperationType.UNSET_REFERENCE, this.allUnsetReferenceModules);
        allModules.put(OperationType.CHANGE_LITERAL, this.allChangeLiteralModules);
        allModules.put(OperationType.CHANGE_REFERENCE, this.allChangeReferenceModules);
        return allModules;
    }
}

